/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.container;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.container.BESPContainer;

public class PluginManager {
    private static final Logger logger;
    private static final Object[] VOID;
    private List plugins = new ArrayList();
    private BESPContainer container = null;
    private Map pluginClassMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.container.PluginManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        VOID = new Object[0];
    }

    public PluginManager(BESPContainer container) {
        this.container = container;
    }

    public List getPlugins() {
        return this.plugins;
    }

    void loadPlugin() {
        logger.debug((Object)"plugin loading start");
        List pluginClasses = this.searchPluginClasses();
        Map dependentMap = this.createDependentMap(pluginClasses);
        this.orderByDependency(pluginClasses, dependentMap);
        this.initializePlugins(pluginClasses, dependentMap);
        logger.debug((Object)("plugin loading completed PluginClassesCount=" + this.plugins.size()));
    }

    void terminatePlugins() {
        ArrayList tmp = new ArrayList(this.plugins);
        Collections.reverse(tmp);
        this.terminatePlugins(tmp);
    }

    private List searchPluginClasses() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.boxed_economy.besp.container.BESPPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> target = clazz;
        ArrayList classes = new ArrayList(BESP.classTreeRoot.getFilteredClasses(target));
        classes.remove(target);
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            Class pluginClass = (Class)i.next();
            logger.info((Object)("found plugin class = " + pluginClass.getName()));
        }
        return classes;
    }

    private void initializePlugins(List pluginClasses, Map dependentMap) {
        Iterator i = pluginClasses.iterator();
        while (i.hasNext()) {
            Class pluginClass = (Class)i.next();
            if (!this.isInitializable(pluginClass, dependentMap)) {
                logger.warn((Object)("cannot initialize plugin for dependency : " + pluginClass.getName()));
                continue;
            }
            if (this.plugins.contains(pluginClass)) {
                logger.debug((Object)("already initialized : " + pluginClass.getName()));
                continue;
            }
            this.initializePlugin(pluginClass);
        }
    }

    private void initializePlugin(Class pluginClass) {
        try {
            this.invokeStaticMethod(pluginClass, "initializePlugin", new Object[]{this.container});
            this.plugins.add(pluginClass);
        }
        catch (Exception ex) {
            logger.warn((Object)("Exception in initializePlugin : pluginClass = " + pluginClass.getName()), (Throwable)ex);
        }
    }

    private Map createDependentMap(List pluginClasses) {
        LinkedHashMap<Class, List> map = new LinkedHashMap<Class, List>();
        Iterator i = pluginClasses.iterator();
        while (i.hasNext()) {
            Class pluginClass = (Class)i.next();
            map.put(pluginClass, this.getDependentClasses(pluginClass));
        }
        return map;
    }

    private List getDependentClasses(Class pluginClass) {
        try {
            Object dependentClasses = this.invokeStaticMethod(pluginClass, "getDependentClasses", VOID);
            if (dependentClasses == null || !(dependentClasses instanceof Class[])) {
                return Collections.EMPTY_LIST;
            }
            Class[] classes = (Class[])dependentClasses;
            ArrayList<Class> list = new ArrayList<Class>();
            int i = 0;
            while (i < classes.length) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.boxed_economy.besp.container.BESPPlugin");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(classes[i])) {
                    logger.warn((Object)("dependentClass is not BESPPlugin plugin : " + pluginClass.getName() + " class : " + classes[i].getName()));
                } else {
                    list.add(classes[i]);
                }
                ++i;
            }
            return list;
        }
        catch (Exception ex) {
            logger.warn((Object)("Exception in getDependentClasses : pluginClass = " + pluginClass.getName()), (Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    private boolean isInitializable(Class pluginClass, Map dependentMap) {
        List dependentClasses = (List)dependentMap.get(pluginClass);
        Iterator i = dependentClasses.iterator();
        while (i.hasNext()) {
            Class dependentClass = (Class)i.next();
            if (this.plugins.contains(dependentClass)) continue;
            return false;
        }
        return true;
    }

    private void orderByDependency(List pluginClasses, Map dependentMap) {
        PluginClass pluginClass;
        ArrayList tmp = new ArrayList(pluginClasses);
        Iterator i = tmp.iterator();
        while (i.hasNext()) {
            Class clazz = (Class)i.next();
            pluginClass = this.getPluginClass(clazz);
            List dependentClasses = (List)dependentMap.get(pluginClass.clazz);
            Iterator j = dependentClasses.iterator();
            while (j.hasNext()) {
                Class dependentClass = (Class)j.next();
                this.getPluginClass(dependentClass).add(pluginClass);
            }
        }
        pluginClasses.clear();
        Iterator k = this.pluginClassMap.values().iterator();
        while (k.hasNext()) {
            pluginClass = (PluginClass)k.next();
            if (!pluginClass.parents.isEmpty()) continue;
            pluginClasses.addAll(pluginClass.getChildrenAsClass());
        }
    }

    private void order(List pluginClasses, Object target, Object dependent) {
        int dependentIndex;
        int targetIndex = pluginClasses.indexOf(target);
        if (targetIndex < (dependentIndex = pluginClasses.indexOf(dependent))) {
            logger.debug((Object)("order target = " + target + " dependent=" + dependent));
            pluginClasses.remove(target);
            pluginClasses.add(dependentIndex, target);
        }
    }

    private void terminatePlugins(List pluginClasses) {
        Iterator i = pluginClasses.iterator();
        while (i.hasNext()) {
            Class pluginClass = (Class)i.next();
            this.terminatePlugin(pluginClass);
        }
    }

    private void terminatePlugin(Class pluginClass) {
        try {
            try {
                this.invokeStaticMethod(pluginClass, "terminatePlugin", new Object[]{this.container});
            }
            catch (Exception ex) {
                logger.warn((Object)("Exception in terminatePlugin : pluginClass = " + pluginClass.getName()), (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.plugins.remove(pluginClass);
            throw throwable;
        }
        Object var3_5 = null;
        this.plugins.remove(pluginClass);
    }

    private Object invokeStaticMethod(Class clazz, String methodName, Object[] parameters) throws Exception {
        Method method = this.searchStaticMethod(clazz, methodName, parameters);
        if (method != null) {
            logger.info((Object)("\"" + method.getName() + "\" found in = " + clazz.getName()));
            return method.invoke(null, parameters);
        }
        return null;
    }

    private Method searchStaticMethod(Class clazz, String methodName, Object[] parameters) {
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals(methodName) && this.equalsParameter(method.getParameterTypes(), parameters) && Modifier.isStatic(method.getModifiers())) {
                return method;
            }
            ++i;
        }
        return null;
    }

    private boolean equalsParameter(Class[] parameterTypes, Object[] parameters) {
        if (parameterTypes.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameterTypes.length) {
            if (!parameterTypes[i].isInstance(parameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private PluginClass getPluginClass(Class clazz) {
        if (this.pluginClassMap.containsKey(clazz)) {
            return (PluginClass)this.pluginClassMap.get(clazz);
        }
        PluginClass pluginClass = new PluginClass();
        pluginClass.clazz = clazz;
        this.pluginClassMap.put(clazz, pluginClass);
        return pluginClass;
    }

    class PluginClass {
        Class clazz = null;
        List parents = new ArrayList();
        List children = new ArrayList();

        PluginClass() {
        }

        public void add(PluginClass child) {
            if (this.getParents().contains(child)) {
                logger.warn((Object)("cannot load for cycle plugin : " + child.clazz));
                return;
            }
            child.parents.add(this);
            this.children.add(child);
        }

        public List getParents() {
            ArrayList<PluginClass> list = new ArrayList<PluginClass>();
            list.add(this);
            Iterator i = this.parents.iterator();
            while (i.hasNext()) {
                PluginClass element = (PluginClass)i.next();
                list.addAll(element.getParents());
            }
            return list;
        }

        public List getChildrenAsClass() {
            ArrayList<Class> list = new ArrayList<Class>();
            list.add(this.clazz);
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                PluginClass child = (PluginClass)i.next();
                list.addAll(child.getChildrenAsClass());
            }
            return list;
        }

        public boolean Equals(Object o) {
            return ((PluginClass)o).clazz == this.clazz;
        }
    }
}

