/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.container.classtree;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.BESPLauncher;
import org.boxed_economy.besp.container.classtree.BoxClass;
import org.boxed_economy.besp.container.classtree.BoxClassTreeElement;
import org.boxed_economy.besp.container.classtree.BoxPackage;
import org.boxed_economy.besp.container.classtree.BoxRootPackage;

public class BoxClassTreeCreator {
    private static final Logger logger;
    private static final String ROOT = ".";
    private static final String DELIMITER = "/";
    private static final String ZIP_EXTENTION = ".zip/";
    private static final String JAR_EXTENTION = ".jar";
    private BoxRootPackage root;
    private ArrayList elements;
    private ArrayList pluginElements;
    private HashMap elementsMap;
    private Stack packageNameStack;
    private ArrayList pluginClassNames;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.container.classtree.BoxClassTreeCreator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    private void initialize() {
        this.elements = new ArrayList();
        this.pluginElements = new ArrayList();
        this.elementsMap = new HashMap();
        this.packageNameStack = new Stack();
        this.pluginClassNames = new ArrayList();
        this.root = new BoxRootPackage(ROOT);
        this.elementsMap.put(ROOT, this.root);
    }

    public BoxRootPackage createFromClassPath() {
        String allClassPath = System.getProperty("java.class.path");
        logger.debug((Object)("start creating classtree (classpath=" + allClassPath + ")"));
        try {
            this.initialize();
            String[] classPaths = this.divideClassPath(allClassPath);
            this.addElementFromFilePaths(classPaths);
            Collections.sort(this.elements);
            Collections.reverse(this.elements);
            this.createBoxClassTreeFromElmList();
        }
        catch (Exception ex) {
            logger.warn((Object)"exception occured !", (Throwable)ex);
        }
        return this.root;
    }

    private URL createJarURL(String path, String entry) throws Exception {
        return new URL("jar:" + new File(path).toURL() + "!/" + entry);
    }

    public BoxClassTreeElement createFromClassArray(Class[] classArray) {
        logger.debug((Object)"start creating class tree");
        try {
            this.initialize();
            this.createElementFromClassArray(classArray);
            Collections.sort(this.elements);
            Collections.reverse(this.elements);
            this.createBoxClassTreeFromElmList();
        }
        catch (Exception ex) {
            logger.warn((Object)"exception caught in creating classtree", (Throwable)ex);
        }
        logger.debug((Object)"creating class tree completed");
        return this.root;
    }

    private String[] divideClassPath(String classPathStr) {
        StringTokenizer st = new StringTokenizer(classPathStr, BESPLauncher.CLASSPATH_SEPARATOR, false);
        String[] trimedArray = new String[st.countTokens()];
        int i = 0;
        while (i < trimedArray.length) {
            trimedArray[i] = st.nextToken();
            ++i;
        }
        return trimedArray;
    }

    private void createElementFromClassArray(Class[] classArray) {
        int i = 0;
        while (i < classArray.length) {
            String className = classArray[i].getName();
            StringTokenizer tokenizer = new StringTokenizer(className, ROOT);
            String elmPathName = "";
            int len = tokenizer.countTokens();
            int j = 0;
            while (j < len) {
                elmPathName = String.valueOf(elmPathName) + DELIMITER + tokenizer.nextToken();
                ++j;
            }
            this.elements.add(ROOT + elmPathName);
            ++i;
        }
    }

    private void addElementFromFilePaths(String[] filePaths) throws Exception {
        int i = 0;
        while (i < filePaths.length) {
            this.addElementFromFilePath(filePaths[i]);
            ++i;
        }
    }

    private void addElementFromFilePath(String filePath) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            logger.warn((Object)("file isn't exist (" + file.getName() + ")"));
            return;
        }
        if (file.getName().toLowerCase().endsWith(JAR_EXTENTION) || file.getName().toLowerCase().endsWith(ZIP_EXTENTION)) {
            JarFile jarfile = new JarFile(file);
            this.addElementFromJar(jarfile);
        } else if (file.isDirectory()) {
            this.addElementFromDir(file, true);
        } else {
            logger.warn((Object)("unknown file = " + file.getName()));
        }
    }

    private String[] getJarfilePathsFromDir(String dirName) throws Exception {
        ArrayList<File> jarfilePaths = new ArrayList<File>();
        File f = new File(dirName);
        if (!f.isDirectory()) {
            logger.warn((Object)("directory isn't exist" + f.getPath()));
            return new String[0];
        }
        File[] files = f.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() && files[i].getAbsolutePath().endsWith(JAR_EXTENTION)) {
                jarfilePaths.add(files[i]);
            }
            ++i;
        }
        String[] strs = new String[jarfilePaths.size()];
        int i2 = 0;
        while (i2 < jarfilePaths.size()) {
            strs[i2] = ((File)jarfilePaths.get(i2)).getAbsolutePath();
            ++i2;
        }
        return strs;
    }

    private void addElementFromJar(JarFile jarfile) throws Exception {
        Enumeration<JarEntry> e = jarfile.entries();
        while (e.hasMoreElements()) {
            String JARPath;
            JarEntry JAREntry = e.nextElement();
            if (JAREntry.isDirectory() || !this.isClass(JARPath = JAREntry.getName())) continue;
            String convertedPath = this.convertJarEntryPath(JARPath);
            this.elements.add(convertedPath);
        }
    }

    private boolean isClass(String str) {
        return str.endsWith(".class");
    }

    private String convertJarEntryPath(String jarpath) {
        String str = this.trimClassExtention(jarpath);
        str = "./" + str;
        return str;
    }

    private void addElementFromDir(File targetDirectory, boolean isRoot) {
        logger.debug((Object)("BoxClassTreeCreator#addToElmMapFromDir " + targetDirectory.toString()));
        if (!isRoot) {
            this.packageNameStack.push(targetDirectory.getName());
        }
        File[] fileElm = targetDirectory.listFiles();
        int i = 0;
        while (i < fileElm.length) {
            if (fileElm[i].isDirectory()) {
                this.addElementFromDir(fileElm[i], false);
            } else {
                String fileName = fileElm[i].getName();
                if (this.isClass(fileName)) {
                    String elmName = this.convertFilePath(fileName);
                    this.elements.add(elmName);
                }
            }
            ++i;
        }
        if (!isRoot) {
            this.packageNameStack.pop();
        }
    }

    private String trimClassExtention(String target) {
        return target.substring(0, target.lastIndexOf(".class"));
    }

    private String convertFilePath(String fileName) {
        String packageName;
        String convertStr = this.trimClassExtention(fileName);
        String createStr = ROOT;
        Stack<String> tmpStack = new Stack<String>();
        int len = this.packageNameStack.size();
        int i = 0;
        while (i < len) {
            packageName = (String)this.packageNameStack.pop();
            tmpStack.push(packageName);
            ++i;
        }
        i = 0;
        while (i < len) {
            packageName = (String)tmpStack.pop();
            createStr = String.valueOf(createStr) + DELIMITER + packageName;
            this.packageNameStack.push(packageName);
            ++i;
        }
        createStr = String.valueOf(createStr) + DELIMITER + convertStr;
        return createStr;
    }

    private void createBoxClassTreeFromElmList() {
        Iterator ite = this.elements.iterator();
        while (ite.hasNext()) {
            this.addTreeElm((String)ite.next(), false);
        }
    }

    private BoxClassTreeElement addTreeElm(String fullPath, boolean isPackage) {
        BoxClassTreeElement existingElm = (BoxClassTreeElement)this.elementsMap.get(fullPath);
        if (existingElm != null) {
            return existingElm;
        }
        BoxClassTreeElement addElm = null;
        String elmName = this.trimElmName(fullPath);
        addElm = isPackage ? new BoxPackage(elmName) : new BoxClass(elmName);
        String belongPackageName = this.trimBelongPackage(fullPath);
        BoxPackage belongPackage = (BoxPackage)this.elementsMap.get(belongPackageName);
        if (belongPackage == null) {
            belongPackage = (BoxPackage)this.addTreeElm(belongPackageName, true);
        }
        belongPackage.add(addElm);
        this.elementsMap.put(fullPath, addElm);
        if (this.pluginElements.contains(fullPath)) {
            this.pluginClassNames.add(addElm.getAbsoluteName());
            logger.debug((Object)("BoxClassTreeCreator#pluginElmList\u306badd\u3055\u308c\u307e\u3059\u3002name=" + addElm.getAbsoluteName()));
        }
        return addElm;
    }

    private String trimBelongPackage(String fullPath) {
        return fullPath.substring(0, fullPath.lastIndexOf(DELIMITER));
    }

    private String trimElmName(String fullPath) {
        return fullPath.substring(fullPath.lastIndexOf(DELIMITER) + 1);
    }
}

