/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.container.classtree;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.classtree.BoxClass;
import org.boxed_economy.besp.container.classtree.BoxClassTreeElement;
import org.boxed_economy.besp.container.classtree.BoxClassTreeVisitor;
import org.boxed_economy.besp.container.classtree.BoxPackage;

public class CleaningInvalidClassBoxClassTreeVisitor
extends BoxClassTreeVisitor {
    private static final Logger logger;
    private static final String[] outOfTargetClass;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.container.classtree.CleaningInvalidClassBoxClassTreeVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        outOfTargetClass = new String[]{"sun", "java", "demos", "javax", "junit", "netscape", "sunw", "com.sun", "org.omg", "tcl"};
    }

    public void visitPackage(BoxPackage target) {
    }

    public void visitClass(BoxClass target) {
        String className = target.getAbsoluteName();
        if (this.isOutOfTargetClass(className)) {
            logger.debug((Object)("out of target class = " + className));
            this.cleanClass(target);
        }
        try {
            Class.forName(className, true, ClassLoader.getSystemClassLoader());
        }
        catch (Throwable th) {
            logger.debug((Object)("Class.forName() error class= " + className));
            this.cleanClass(target);
        }
    }

    private void cleanClass(BoxClass target) {
        BoxClassTreeElement parent = (BoxClassTreeElement)target.getParent();
        if (parent != null && parent instanceof BoxPackage) {
            ((BoxPackage)parent).remove(target);
        }
    }

    private boolean isOutOfTargetClass(String className) {
        int i = 0;
        while (i < outOfTargetClass.length) {
            if (className.startsWith(outOfTargetClass[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

