/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorManager;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Entity;
import org.boxed_economy.besp.model.fmfw.FMFWConstants;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.GoodsManager;
import org.boxed_economy.besp.model.fmfw.GoodsQuantity;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.OpenChannelEvent;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.RelationManager;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentEvent;

public final class Agent
extends Entity {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private AgentType type = null;
    private GoodsManager goodsManager = null;
    private RelationManager relationManager = null;
    private BehaviorManager behaviorManager = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.Agent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected Agent(AgentType type) {
        this.type = type;
    }

    public void initialize() {
        this.goodsManager = new GoodsManager();
        this.relationManager = new RelationManager(this);
        this.behaviorManager = new BehaviorManager(this);
    }

    public AgentType getType() {
        return this.type;
    }

    public void destroy() {
        this.behaviorManager.removeAllBehaviors();
        this.getWorld().destroyAgent(this);
    }

    public void receiveTimeEvent(TimeEvent e) {
        this.behaviorManager.receiveTimeEvent(e);
    }

    public void receiveDeathEvent(Agent target) {
        this.relationManager.removeRelationsByAgent(target);
    }

    public void putInformation(Information key, Information value) {
        super.putInformation(key, value);
        this.fireInformationAdded(new UpdateAgentEvent(this, value));
    }

    public Information getInformation(Information key) {
        return super.getInformation(key);
    }

    public Information removeInformation(Information key) {
        Information value = super.removeInformation(key);
        this.fireInformationRemoved(new UpdateAgentEvent(this, value));
        return value;
    }

    public void addBehavior(BehaviorType type) {
        try {
            Class<?> behaviorClass = Class.forName(type.getName());
            Behavior newBehavior = (Behavior)behaviorClass.newInstance();
            newBehavior.setType(type);
            this.behaviorManager.addBehavior(newBehavior);
            this.fireBehaviorAdded(new UpdateAgentEvent(this, newBehavior));
            newBehavior.run();
        }
        catch (Exception ex) {
            throw new ModelException("caught exception in addBehavior", ex);
        }
    }

    public void removeBehavior(Behavior behavior) {
        this.behaviorManager.removeBehavior(behavior);
        this.fireBehaviorRemoved(new UpdateAgentEvent(this, behavior));
    }

    public Behavior getBehavior(BehaviorType type) {
        return this.behaviorManager.getBehavior(type);
    }

    public Collection getBehaviors(BehaviorType type) {
        return this.behaviorManager.getBehaviors(type);
    }

    public Collection getBehaviorsRecursively(BehaviorType type) {
        return this.behaviorManager.getBehaviorsRecursively(type);
    }

    public List getAllBehaviors() {
        return this.behaviorManager.getAllBehaviors();
    }

    public Behavior receiveOpenChannelEvent(OpenChannelEvent e) {
        return this.behaviorManager.receiveOpenChannelEvent(e);
    }

    public void addGoods(Goods goods) {
        this.goodsManager.addGoods(goods);
        this.fireGoodsAdded(new UpdateAgentEvent(this, goods));
    }

    public Goods removeGoods(GoodsType type, double quantity) {
        Goods target = this.goodsManager.removeGoods(type, quantity);
        this.fireGoodsRemoved(new UpdateAgentEvent(this, target));
        return target;
    }

    public Collection removeGoodsRecursively(GoodsType type, double quantity) {
        List target = this.goodsManager.removeGoodsRecursively(type, quantity);
        this.fireGoodsRemoved(new UpdateAgentEvent(this, target));
        return target;
    }

    public Goods removeAllGoods(GoodsType type) {
        Goods target = this.goodsManager.removeAllGoods(type);
        this.fireGoodsRemoved(new UpdateAgentEvent(this, target));
        return target;
    }

    public Collection removeAllGoodsRecursively(GoodsType type) {
        Collection target = this.goodsManager.removeAllGoodsRecursively(type);
        this.fireGoodsRemoved(new UpdateAgentEvent(this, target));
        return target;
    }

    public GoodsQuantity getQuantity(GoodsType type) {
        return this.goodsManager.getQuantity(type);
    }

    public GoodsQuantity getQuantityRecursively(GoodsType type) {
        return this.goodsManager.getQuantityRecursively(type);
    }

    public boolean hasGoods(GoodsType type) {
        return this.getQuantityRecursively(type).getValueAsDouble() > 0.0;
    }

    public Collection getGoodsTypes() {
        return this.goodsManager.getGoodsTypes();
    }

    public void addRelation(Agent target) {
        this.addRelation(FMFWConstants.RELATIONTYPE_DEFAULT, target);
    }

    public void addRelation(RelationType relationType, Agent target) {
        Relation newRelation = new Relation(relationType, this, target);
        this.relationManager.addRelation(newRelation);
        this.fireRelationAdded(new UpdateAgentEvent(this, newRelation));
    }

    public void removeRelation(Relation relation) {
        this.relationManager.removeRelation(relation);
        this.fireRelationRemoved(new UpdateAgentEvent(this, relation));
    }

    public void removeRelations(RelationType type) {
        this.relationManager.removeRelations(type);
    }

    public void removeRelationsRecursively(RelationType type) {
        this.relationManager.removeRelationsRecursively(type);
    }

    public Collection getRelationTypes() {
        return this.relationManager.getRelationTypes();
    }

    public Relation getRelation(RelationType type) {
        return this.relationManager.getRelation(type);
    }

    public Collection getRelations(RelationType type) {
        return this.relationManager.getRelations(type);
    }

    public List getAllRelations() {
        return this.relationManager.getAllRelations();
    }

    public Collection getRelationsRecursively(RelationType type) {
        return this.relationManager.getRelationsRecursively(type);
    }

    public Relation getRelation(RelationType type, Agent agent) {
        return this.relationManager.getRelation(type, agent);
    }

    protected void fireGoodsAdded(UpdateAgentEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().goodsAdded(e);
        }
    }

    protected void fireGoodsRemoved(UpdateAgentEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().goodsRemoved(e);
        }
    }

    protected void fireInformationAdded(UpdateAgentEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().informationAdded(e);
        }
    }

    protected void fireInformationRemoved(UpdateAgentEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().informationRemoved(e);
        }
    }

    protected void fireRelationAdded(UpdateAgentEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().relationAdded(e);
        }
    }

    protected void fireRelationRemoved(UpdateAgentEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().relationRemoved(e);
        }
    }

    protected void fireBehaviorAdded(UpdateAgentEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().behaviorAdded(e);
        }
    }

    protected void fireBehaviorRemoved(UpdateAgentEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().behaviorRemoved(e);
        }
    }
}

