/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.DeathEvent;
import org.boxed_economy.besp.model.fmfw.OpenChannelEvent;
import org.boxed_economy.besp.model.fmfw.TimeEvent;

public class BehaviorManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private Agent agent;
    private HashMap behaviorMap = new LinkedHashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.BehaviorManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected BehaviorManager(Agent agent) {
        logger.debug((Object)"IN");
        this.agent = agent;
        logger.debug((Object)"OUT");
    }

    public void addBehavior(Behavior behavior) {
        logger.debug((Object)"IN");
        behavior.setAgent(this.agent);
        this.addBehaviorToMap(behavior);
        logger.debug((Object)"OUT");
    }

    public void removeBehavior(Behavior behavior) {
        logger.debug((Object)"IN");
        behavior.stop();
        this.removeBehaviorFromMap(behavior);
        logger.debug((Object)"OUT");
    }

    public Behavior getBehavior(BehaviorType type) {
        Collection c = this.getBehaviors(type);
        if (c.isEmpty()) {
            throw new ModelException(String.valueOf(type.toString()) + "is not existed !");
        }
        return (Behavior)c.iterator().next();
    }

    public Collection getBehaviors(BehaviorType type) {
        logger.debug((Object)"IN");
        List value = (List)this.behaviorMap.get(type);
        if (value == null || value.isEmpty()) {
            return new ArrayList();
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    public Collection getBehaviorsRecursively(BehaviorType type) {
        logger.debug((Object)"IN");
        Collection value = this.getBehaviors(type);
        Iterator i = type.getChildrenRecursively().iterator();
        while (i.hasNext()) {
            BehaviorType t = (BehaviorType)i.next();
            value.addAll(this.getBehaviors(t));
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    public List getAllBehaviors() {
        ArrayList<Behavior> behaviors = new ArrayList<Behavior>();
        Collection behaviorsLists = this.behaviorMap.values();
        Iterator i = behaviorsLists.iterator();
        while (i.hasNext()) {
            List behaviorsList = (List)i.next();
            Iterator j = behaviorsList.iterator();
            while (j.hasNext()) {
                Behavior element = (Behavior)j.next();
                behaviors.add(element);
            }
        }
        return behaviors;
    }

    public Behavior receiveOpenChannelEvent(OpenChannelEvent e) {
        logger.debug((Object)"IN");
        List behaviors = (List)this.getBehaviorsRecursively(e.getTargetBehaviorType());
        Iterator i = behaviors.iterator();
        while (i.hasNext()) {
            Behavior b = (Behavior)i.next();
            if (!b.isReceivableEvent(e)) continue;
            return b;
        }
        return behaviors.isEmpty() ? null : (Behavior)behaviors.get(0);
    }

    public void receiveTimeEvent(TimeEvent e) {
        logger.debug((Object)"IN");
        Iterator i = this.getAllBehaviorList().iterator();
        while (i.hasNext()) {
            Behavior b = (Behavior)i.next();
            b.receiveEvent(e);
        }
        logger.debug((Object)"OUT");
    }

    public void removeAllBehaviors() {
        logger.debug((Object)"IN");
        Iterator i = this.getAllBehaviorList().iterator();
        while (i.hasNext()) {
            Behavior b = (Behavior)i.next();
            b.receiveEvent(new DeathEvent(this));
            this.removeBehavior(b);
        }
        logger.debug((Object)"OUT");
    }

    private List getAllBehaviorList() {
        logger.debug((Object)"IN");
        ArrayList value = new ArrayList();
        Iterator i = this.behaviorMap.values().iterator();
        while (i.hasNext()) {
            List l = (List)i.next();
            value.addAll(l);
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    private void addBehaviorToMap(Behavior behavior) {
        logger.debug((Object)"IN");
        ArrayList<Behavior> list = (ArrayList<Behavior>)this.behaviorMap.get(behavior.getType());
        if (list != null) {
            if (list.contains(behavior)) {
                list.remove(behavior);
            }
        } else {
            list = new ArrayList<Behavior>();
            this.behaviorMap.put(behavior.getType(), list);
        }
        list.add(behavior);
        logger.debug((Object)"OUT");
    }

    private void removeBehaviorFromMap(Behavior behavior) {
        logger.debug((Object)"IN");
        List list = (List)this.behaviorMap.get(behavior.getType());
        if (list != null) {
            if (!list.contains(behavior)) {
                logger.debug((Object)"OUT(Exception)");
                throw new ModelException("AbstractBehavior not found ! " + behavior);
            }
        } else {
            throw new ModelException("AbstractBehavior Type not found ! " + behavior);
        }
        list.remove(behavior);
        logger.debug((Object)"OUT");
    }
}

