/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.FmFwObject;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.update.TradeEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelEvent;
import org.boxed_economy.besp.presentation.PresentationContainer;

public final class Channel
extends FmFwObject {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private Relation parentRelation = null;
    private Behavior behaviorA = null;
    private Behavior behaviorB = null;
    private Goods sendingGoods = null;
    private Collection goodsFromBehaviorA = new ArrayList();
    private Collection goodsFromBehaviorB = new ArrayList();
    private boolean keep = false;
    private boolean closed = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.Channel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected Channel(Relation parentRelation, Behavior behaviorA, Behavior behaviorB, boolean keep) {
        this.parentRelation = parentRelation;
        this.behaviorA = behaviorA;
        this.behaviorB = behaviorB;
        this.keep = keep;
    }

    public Relation getParentRelation() {
        return this.parentRelation;
    }

    public Behavior getBehaviorB() {
        return this.behaviorB;
    }

    public Behavior getBehaviorA() {
        return this.behaviorA;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        logger.debug((Object)"IN");
        this.behaviorA.removeChannel(this);
        this.behaviorB.removeChannel(this);
        this.parentRelation.removeChannel(this);
        this.closed = true;
        this.fireTradeCompleted(new TradeEvent(this, this.goodsFromBehaviorA, this.goodsFromBehaviorB, this.parentRelation));
    }

    public Goods receiveGoods(Behavior behavior) {
        logger.debug((Object)"IN");
        if (this.closed) {
            throw new ModelException("receiveGoods called in illegal state (closed)");
        }
        if (behavior != this.behaviorA && behavior != this.behaviorB) {
            throw new ModelException("illegal behavior in receiveGoods");
        }
        Behavior targetBehavior = null;
        Behavior sourceBehavior = null;
        if (behavior == this.behaviorA) {
            sourceBehavior = this.behaviorB;
            targetBehavior = this.behaviorA;
        } else if (behavior == this.behaviorB) {
            sourceBehavior = this.behaviorA;
            targetBehavior = this.behaviorB;
        }
        Collection goodsList = null;
        if (behavior == this.behaviorB) {
            goodsList = this.goodsFromBehaviorA;
        } else if (behavior == this.behaviorA) {
            goodsList = this.goodsFromBehaviorB;
        }
        goodsList.add(this.sendingGoods);
        this.fireGoodsReceive(new UpdateChannelEvent(this, this.sendingGoods, sourceBehavior, targetBehavior));
        Goods returnGoods = this.sendingGoods;
        this.sendingGoods = null;
        return returnGoods;
    }

    public void sendGoods(Goods goods, Behavior behavior) {
        logger.debug((Object)"IN");
        if (this.closed) {
            throw new ModelException("sendGoods called in illegal state (closed)");
        }
        if (behavior != this.behaviorA && behavior != this.behaviorB) {
            throw new ModelException("illegal behavior in sendGoods");
        }
        this.sendingGoods = goods;
        Behavior targetBehavior = null;
        Behavior sourceBehavior = null;
        if (behavior == this.behaviorA) {
            sourceBehavior = this.behaviorA;
            targetBehavior = this.behaviorB;
        } else if (behavior == this.behaviorB) {
            sourceBehavior = this.behaviorB;
            targetBehavior = this.behaviorA;
        }
        this.fireGoodsSend(new UpdateChannelEvent(this, goods, sourceBehavior, targetBehavior));
        targetBehavior.receiveEvent(new ChannelEvent(this));
    }

    private void fireTradeCompleted(TradeEvent event) {
        if (this.getContainer() != null) {
            this.getContainer().getUpdateEventManager().tradeCompleted(event);
        }
    }

    private void fireGoodsSend(UpdateChannelEvent event) {
        if (this.getContainer() != null) {
            this.getContainer().getUpdateEventManager().goodsSent(event);
        }
    }

    private void fireGoodsReceive(UpdateChannelEvent event) {
        if (this.getContainer() != null) {
            this.getContainer().getUpdateEventManager().goodsReceive(event);
        }
    }

    private PresentationContainer getContainer() {
        return this.getParentRelation().getSource().getWorld().getPresentationContainer();
    }
}

