/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FmFwObject
implements Serializable {
    private static Map instanceCounters = new TreeMap();

    public static final List getInstanceCounters() {
        return new ArrayList(instanceCounters.values());
    }

    public FmFwObject() {
        this.getCounter().created();
    }

    protected void finalize() throws Throwable {
        this.getCounter().destroyed();
    }

    private InstanceCounter getCounter() {
        String key = this.getClass().getName();
        if (!instanceCounters.containsKey(key)) {
            instanceCounters.put(key, new InstanceCounter(this.getClass()));
        }
        return (InstanceCounter)instanceCounters.get(key);
    }

    public class InstanceCounter {
        private String name = null;
        private long alive = 0L;
        private long allocated = 0L;

        public InstanceCounter(Class clazz) {
            this.name = clazz.getName();
        }

        public void created() {
            ++this.alive;
            ++this.allocated;
        }

        public void destroyed() {
            --this.alive;
        }

        public String getName() {
            return this.name;
        }

        public long getAlive() {
            return this.alive;
        }

        public long getAllocated() {
            return this.allocated;
        }
    }
}

