/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation.bface.menu;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.besp.presentation.PresentationException;
import org.boxed_economy.besp.presentation.bface.menu.MenuElement;
import org.boxed_economy.besp.presentation.bface.menu.MenuElementGroupEvent;
import org.boxed_economy.besp.presentation.bface.menu.MenuElementGroupListener;

public abstract class MenuElementGroup
extends MenuElement
implements MenuElementGroupListener {
    private List elements = new ArrayList();
    private Vector actionGroupListeners;

    public MenuElementGroup() {
    }

    public MenuElementGroup(String name) {
        super(name);
    }

    public void add(MenuElement element) {
        this.add(element, this.elements.size());
    }

    public void add(MenuElement element, int index) {
        element.setPresentationContainer(this.getPresentationContainer());
        this.elements.add(index, element);
        if (element instanceof MenuElementGroup) {
            ((MenuElementGroup)element).addActionGroupListener(this);
        }
        this.refresh();
        this.fireStateChanged(new MenuElementGroupEvent(this));
    }

    public MenuElement remove(int index) {
        MenuElement element = (MenuElement)this.elements.get(index);
        this.remove(element);
        return element;
    }

    public void remove(MenuElement element) {
        this.elements.remove(element);
        if (element instanceof MenuElementGroup) {
            ((MenuElementGroup)element).removeActionGroupListener(this);
        }
        this.refresh();
        this.fireStateChanged(new MenuElementGroupEvent(this));
    }

    public List getElements() {
        return new ArrayList(this.elements);
    }

    protected void setPresentationContainer(PresentationContainer container) {
        super.setPresentationContainer(container);
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            MenuElement element = (MenuElement)i.next();
            element.setPresentationContainer(container);
        }
    }

    public void stateChanged(MenuElementGroupEvent ev) {
        this.refresh();
    }

    protected void refresh() {
    }

    public final void actionPerformed(ActionEvent e) {
        throw new PresentationException("actionPerformed is not supported");
    }

    public void setEnabled(boolean enabled) {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            MenuElement element = (MenuElement)i.next();
            element.setEnabled(enabled);
        }
    }

    public synchronized void addActionGroupListener(MenuElementGroupListener l) {
        Vector v;
        Vector vector = v = this.actionGroupListeners == null ? new Vector(2) : (Vector)this.actionGroupListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionGroupListeners = v;
        }
    }

    public synchronized void removeActionGroupListener(MenuElementGroupListener l) {
        if (this.actionGroupListeners != null && this.actionGroupListeners.contains(l)) {
            Vector v = (Vector)this.actionGroupListeners.clone();
            v.removeElement(l);
            this.actionGroupListeners = v;
        }
    }

    protected void fireStateChanged(MenuElementGroupEvent e) {
        if (this.actionGroupListeners != null) {
            Vector listeners = this.actionGroupListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((MenuElementGroupListener)listeners.elementAt(i)).stateChanged(e);
                ++i;
            }
        }
    }
}

