/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation.guifw;

import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.besp.presentation.PresentationComponent;
import org.boxed_economy.besp.presentation.PresentationContainerEvent;
import org.boxed_economy.besp.presentation.PresentationContainerListener;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.besp.presentation.bface.menu.Menu;
import org.boxed_economy.besp.presentation.bface.menu.MenuElement;
import org.boxed_economy.besp.presentation.bface.menu.MenuElementGroup;
import org.boxed_economy.besp.presentation.guifw.BoxSplashWindow;
import org.boxed_economy.besp.presentation.guifw.GUIComponent;
import org.boxed_economy.besp.presentation.guifw.GUIComponentManagementDialog;
import org.boxed_economy.besp.presentation.guifw.GUIComponentManager;
import org.boxed_economy.besp.presentation.guifw.MainFrame;
import org.boxed_economy.besp.presentation.guifw.MenuManager;
import org.boxed_economy.besp.presentation.guifw.ShowDialogAction;

public class GUIContainer
extends AbstractPresentationComponent
implements PresentationContainerListener {
    public static ResourceBundle resource;
    public static final String DEFAULT_ICON_IMAGE_PATH = "image/boxicon.gif";
    public static final String TITLE_IMAGE_PATH = "image/title.gif";
    private GUIComponentManager guiComponentManager = null;
    private MenuManager menuManager = null;
    private MainFrame mainFrame = null;
    private BoxSplashWindow splashWindow = null;
    public Menu toolsMenu = new Menu();
    public MenuElementGroup toolsFirstGroup = new ActionGroup();
    public MenuElementGroup toolsDefaultGroup = new ActionGroup();
    public MenuElementGroup toolsLastGroup = new ActionGroup();
    public Menu showMenu = new Menu();
    public MenuElementGroup showFirstGroup = new ActionGroup();
    public MenuElementGroup showGeneralGroup = new ActionGroup();
    public MenuElementGroup showDefaultGroup = new ActionGroup();
    public MenuElementGroup showLastGroup = new ActionGroup();
    private ActionGroup guiComponentManagementGroup = new ActionGroup();
    public ShowDialogAction showGuiComponentManagementAction = new ShowDialogAction();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.presentation.guifw.GUIContainerResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        resource = ResourceBundle.getBundle(clazz.getName());
    }

    public void initialize() {
        this.initializeGuiComponentManager();
        this.initializeMainWindow();
        this.initializeMenuManager();
        this.initializeMenu();
    }

    private void initializeGuiComponentManager() {
        this.guiComponentManager = new GUIComponentManager(this.getPresentationContainer().getMainFrame());
        Iterator i = this.getPresentationContainer().getPresentationComponents().iterator();
        while (i.hasNext()) {
            PresentationComponent element = (PresentationComponent)i.next();
            if (!(element instanceof GUIComponent)) continue;
            this.guiComponentManager.addGUIComponent((GUIComponent)element);
        }
    }

    private void initializeMainWindow() {
        this.getPresentationContainer().addPresentationComponent(this.getMainFrame());
    }

    private void initializeMenuManager() {
        this.getMenuManager().setPresentationContainer(this.getPresentationContainer());
        this.getMenuManager().initialize();
        this.getMainFrame().setJMenuBar(this.getMenuManager().getJMenuBar());
    }

    private void initializeMenu() {
        this.initializeToolsMenu();
        this.initializeShowMenu();
    }

    private void initializeToolsMenu() {
        this.getMenuManager().extendMenuGroup.add(this.toolsMenu);
        this.toolsMenu.setName(resource.getString("Menu_Tools"));
        this.toolsMenu.add(this.toolsFirstGroup);
        this.toolsMenu.add(this.toolsDefaultGroup);
        this.toolsMenu.add(this.toolsLastGroup);
    }

    private void initializeShowMenu() {
        this.getMenuManager().showMenuGroup.add(this.showMenu);
        this.showMenu.setName(resource.getString("Menu_Show"));
        this.showMenu.add(this.showFirstGroup);
        this.showMenu.add(this.showGeneralGroup);
        this.showMenu.add(this.showDefaultGroup);
        this.showMenu.add(this.showLastGroup);
        this.showMenu.add(this.guiComponentManagementGroup);
        GUIComponentManagementDialog guiDialog = new GUIComponentManagementDialog(this.getPresentationContainer(), this.getMainFrame());
        this.showGuiComponentManagementAction.setDialog(guiDialog);
        this.showGuiComponentManagementAction.setName(resource.getString("Menu_AllClose"));
        this.guiComponentManagementGroup.add(this.showGuiComponentManagementAction);
    }

    public void terminate() {
        this.getPresentationContainer().removePresentationComponent(this.mainFrame);
    }

    public MainFrame getMainFrame() {
        if (this.mainFrame == null) {
            this.mainFrame = new MainFrame();
        }
        return this.mainFrame;
    }

    public MenuManager getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
        }
        return this.menuManager;
    }

    public BoxSplashWindow getSplashWindow() {
        if (this.splashWindow == null) {
            this.splashWindow = new BoxSplashWindow(this.getMainFrame());
        }
        return this.splashWindow;
    }

    public void addMenuElementToShowMenu(MenuElement element) {
        this.showDefaultGroup.add(element);
    }

    public void addMenuElementToToolsMenu(MenuElement element) {
        this.toolsDefaultGroup.add(element);
    }

    public void presentationComponentAdded(PresentationContainerEvent ev) {
        PresentationComponent component = ev.getPresentationComponent();
        if (component instanceof GUIComponent) {
            this.guiComponentManager.addGUIComponent((GUIComponent)component);
        }
    }

    public void presentationComponentRemoved(PresentationContainerEvent ev) {
        PresentationComponent component = ev.getPresentationComponent();
        if (component instanceof GUIComponent) {
            this.guiComponentManager.removeGUIComponent((GUIComponent)component);
        }
    }

    public List getGUIComponents() {
        return this.guiComponentManager.getGUIComponents();
    }
}

