/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation.guifw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JDesktopPane;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.presentation.guifw.AbstractFrameComponent;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.besp.presentation.guifw.MainFrameProperty;
import org.boxed_economy.besp.presentation.guifw.ParetteLayerInternalFrame;

public class MainFrame
extends AbstractFrameComponent {
    private static final Logger logger;
    private static final Color DESKTOP_BG_COLOR;
    private static final String TITLE = "Boxed Economy Simulation Platform";
    private JDesktopPane desktop = new JDesktopPane();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.presentation.guifw.MainFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        DESKTOP_BG_COLOR = Color.white;
    }

    protected void initializeWindow() {
    }

    public void initialize() {
        this.initializeFrame();
        this.initializeDefaultCloseOperation();
        this.initializeIcon();
        this.initizalizeDesktop();
        this.loadProperty();
    }

    protected void initializeFrame() {
        this.setTitle(TITLE);
        Dimension screenSize = this.getToolkit().getScreenSize().getSize();
        Dimension windowSize = new Dimension(screenSize.width - 100, screenSize.height - 100);
        this.setSize(windowSize);
        this.setLocation(50, 20);
    }

    protected void initializeDefaultCloseOperation() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BESP.terminate();
            }
        });
    }

    private void initizalizeDesktop() {
        this.desktop.setBackground(DESKTOP_BG_COLOR);
        this.getContentPane().add(this.desktop);
    }

    public void terminate() {
        this.saveProperty();
    }

    void addInternalFrame(AbstractInternalFrameComponent internalFrame) {
        if (internalFrame instanceof ParetteLayerInternalFrame) {
            this.desktop.add(internalFrame, JDesktopPane.PALETTE_LAYER, 0);
        } else {
            this.desktop.add((Component)internalFrame, 0);
        }
    }

    void removeInternalFrame(AbstractInternalFrameComponent internalFrame) {
        if (Arrays.asList(this.desktop.getComponents()).contains(internalFrame)) {
            this.desktop.remove(internalFrame);
        }
    }

    private void saveProperty() {
        MainFrameProperty property = new MainFrameProperty();
        property.state = this.getState();
        property.bounds = this.getBounds();
        BESP.property.put(this.getClass(), property);
    }

    private void loadProperty() {
        MainFrameProperty property = (MainFrameProperty)BESP.property.get(this.getClass());
        if (property != null) {
            this.setBounds(property.bounds);
            this.setState(property.state);
        }
    }
}

