/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.boxlf5;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.lf5.Log4JLogRecord;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.boxed_economy.components.boxlf5.BoxLF5LogBrokerMonitor;

public class BoxLF5Appender
extends AppenderSkeleton {
    private static BoxLF5LogBrokerMonitor monitor = null;
    private static boolean active = true;

    private static void initializeMonitor() {
        if (monitor == null) {
            monitor = new BoxLF5LogBrokerMonitor(LogLevel.getLog4JLevels());
        }
    }

    public static BoxLF5LogBrokerMonitor getMonitor() {
        return monitor;
    }

    public static void setActive(boolean active) {
        BoxLF5Appender.active = active;
    }

    public static boolean isActive() {
        return active;
    }

    public BoxLF5Appender() {
        BoxLF5Appender.initializeMonitor();
    }

    protected void append(LoggingEvent event) {
        if (!BoxLF5Appender.isActive()) {
            return;
        }
        if (monitor != null) {
            Log4JLogRecord record = this.createRecord(event);
            monitor.addMessage((LogRecord)record);
        }
    }

    protected Log4JLogRecord createRecord(LoggingEvent event) {
        String category = event.categoryName;
        String logMessage = event.getRenderedMessage();
        String nestedDiagnosticContext = event.getNDC();
        String threadDescription = event.getThreadName();
        String level = event.level.toString();
        long time = event.timeStamp;
        LocationInfo locationInfo = event.getLocationInformation();
        Log4JLogRecord record = new Log4JLogRecord();
        record.setCategory(category);
        record.setMessage(logMessage);
        record.setLocation(locationInfo.fullInfo);
        record.setMillis(time);
        record.setThreadDescription(threadDescription);
        if (nestedDiagnosticContext != null) {
            record.setNDC(nestedDiagnosticContext);
        } else {
            record.setNDC("");
        }
        if (event.getThrowableInformation() != null) {
            record.setThrownStackTrace(event.getThrowableInformation());
        }
        try {
            record.setLevel(LogLevel.valueOf((String)level));
        }
        catch (LogLevelFormatException e) {
            record.setLevel(LogLevel.WARN);
        }
        return record;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

