/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.cell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Space;
import org.boxed_economy.components.cell.Cell;
import org.boxed_economy.components.cell.CellScope;

public class CellSpace
implements Space {
    private int xCellNum;
    private int yCellNum;
    private boolean isLoop = true;
    private List[][] cellList;
    private Map agentList = new HashMap();

    public CellSpace(int xCellNum, int yCellNum, boolean isRound) {
        this.xCellNum = xCellNum;
        this.yCellNum = yCellNum;
        this.isLoop = isRound;
        this.cellList = new List[xCellNum][yCellNum];
    }

    public void moveAgent(Agent agent, Cell newCell) {
        if (!this.xyRangeValid(newCell.getX(), newCell.getY())) {
            throw new ModelException("Invalid Cell (" + newCell.getX() + "," + newCell.getY() + ")");
        }
        this.removeAgent(agent);
        this.addAgent(agent, newCell.getX(), newCell.getY());
    }

    public void addAgent(Agent agent, int x, int y) {
        if (!this.xyRangeValid(x, y)) {
            throw new ModelException("Invalid Cell(" + x + "," + y + ")");
        }
        if (this.agentList.containsKey(agent)) {
            throw new ModelException("Already Agent exist !");
        }
        if (this.cellList[x][y] == null) {
            this.cellList[x][y] = new LinkedList();
        }
        this.cellList[x][y].add(agent);
        this.agentList.put(agent, new Cell(x, y));
    }

    public void removeAgent(Agent agent) {
        if (!this.agentList.containsKey(agent)) {
            throw new ModelException("Agent is not exist in AgentList");
        }
        Cell cell = (Cell)this.agentList.get(agent);
        if (!this.cellList[cell.getX()][cell.getY()].contains(agent)) {
            throw new ModelException("Agent is not exist in CellList");
        }
        this.agentList.remove(agent);
        this.cellList[cell.getX()][cell.getY()].remove(agent);
        if (this.agentList.containsKey(agent)) {
            throw new ModelException("Agent is exist in AgentList yet");
        }
        if (this.cellList[cell.getX()][cell.getY()].contains(agent)) {
            throw new ModelException("Agent is exist in CellList yet");
        }
    }

    public Cell getCell(Agent agent) {
        if (!this.agentList.containsKey(agent)) {
            throw new ModelException("\u305d\u306e\u3088\u3046\u306a\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return (Cell)this.agentList.get(agent);
    }

    public Collection getAgents(Cell cell) {
        if (this.cellList[cell.getX()][cell.getY()] == null) {
            return new ArrayList();
        }
        return new ArrayList(this.cellList[cell.getX()][cell.getY()]);
    }

    public Collection getAgents(int x, int y) {
        return this.getAgents(new Cell(x, y));
    }

    public Collection getCells(Agent centerAgent, CellScope scope) {
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        Cell centerCell = this.getCell(centerAgent);
        List relativeCells = scope.getRelativeCells();
        Iterator i = relativeCells.iterator();
        while (i.hasNext()) {
            Cell relativeCell = (Cell)i.next();
            Cell absoluteCell = null;
            absoluteCell = this.isLoop ? this.getAbsoluteCellRound(centerCell, relativeCell) : this.getAbsoluteCellNotRound(centerCell, relativeCell);
            if (absoluteCell == null) continue;
            cellList.add(absoluteCell);
        }
        return cellList;
    }

    public Collection getAgents(Agent centerAgent, CellScope scope) {
        ArrayList agents = new ArrayList();
        Iterator i = this.getCells(centerAgent, scope).iterator();
        while (i.hasNext()) {
            Cell element = (Cell)i.next();
            agents.addAll(this.getAgents(element));
        }
        return agents;
    }

    public Cell getCell(int x, int y) {
        return new Cell(x, y);
    }

    public int getAgentCount() {
        return this.agentList.size();
    }

    public int getXCellNum() {
        return this.xCellNum;
    }

    public int getYCellNum() {
        return this.yCellNum;
    }

    private Cell getAbsoluteCellRound(Cell center, Cell relative) {
        int x = center.getX() + relative.getX();
        int y = center.getY() + relative.getY();
        while (x < 0) {
            x += this.xCellNum;
        }
        x %= this.xCellNum;
        while (y < 0) {
            y += this.yCellNum;
        }
        return new Cell(x, y %= this.yCellNum);
    }

    private Cell getAbsoluteCellNotRound(Cell center, Cell relative) {
        int y;
        int x = center.getX() + relative.getX();
        if (this.xyRangeValid(x, y = center.getY() + relative.getY())) {
            return new Cell(x, y);
        }
        return null;
    }

    private boolean xRangeValid(int x) {
        return x < this.xCellNum && x >= 0;
    }

    private boolean yRangeValid(int y) {
        return y < this.yCellNum && y >= 0;
    }

    private boolean xyRangeValid(int x, int y) {
        return this.xRangeValid(x) && this.yRangeValid(y);
    }
}

