/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.commviewer.controller;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.ac.keio.sfc.crew.swing.layout.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.view.sgef.animation.AbstractAnimationThread;
import org.boxed_economy.components.commviewer.CommunicationViewer;
import org.boxed_economy.components.commviewer.controller.AbstractCommunicationViewerSettingPanel;

public class AnimationSettingPanel
extends AbstractCommunicationViewerSettingPanel {
    private AbstractAnimationThread thread;
    private JCheckBox cEnableCheckBox;
    private JCheckBox cLoopCheckBox;
    private JSlider cSmoothSlider;
    private JSlider cIntervalSlider;

    public AnimationSettingPanel(CommunicationViewer viewer, AbstractAnimationThread thread) {
        super(viewer);
        this.setThread(thread);
    }

    protected void initializeComponent() {
        this.setLayout(new VerticalFlowLayout());
    }

    protected void initializeChildComponents() {
        this.cEnableCheckBox = new JCheckBox(AbstractCommunicationViewerSettingPanel.resource.getString("control_animation_enable"));
        this.add(this.cEnableCheckBox);
        this.cEnableCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AnimationSettingPanel.this.thread.setEnable(AnimationSettingPanel.this.cEnableCheckBox.isSelected());
            }
        });
        this.cLoopCheckBox = new JCheckBox(AbstractCommunicationViewerSettingPanel.resource.getString("control_animation_loop"));
        this.add(this.cLoopCheckBox);
        this.cLoopCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AnimationSettingPanel.this.thread.setLoop(AnimationSettingPanel.this.cLoopCheckBox.isSelected());
            }
        });
        JLabel smoothLabel = this.createSmoothLabel();
        this.add(smoothLabel);
        this.cSmoothSlider = this.createSmoothSlider();
        this.add(this.cSmoothSlider);
        this.cSmoothSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnimationSettingPanel.this.thread.setStepCount(AnimationSettingPanel.this.cSmoothSlider.getValue());
            }
        });
        JLabel intervalLabel = this.createIntervalLabel();
        this.add(intervalLabel);
        this.cIntervalSlider = this.createIntervalSlider();
        this.add(this.cIntervalSlider);
        this.cIntervalSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AnimationSettingPanel.this.thread.setInterval(AnimationSettingPanel.this.cIntervalSlider.getValue());
            }
        });
    }

    protected JLabel createSmoothLabel() {
        return new JLabel(AbstractCommunicationViewerSettingPanel.resource.getString("control_animation_smooth"));
    }

    protected JSlider createSlider() {
        JSlider slider = new JSlider();
        slider.setPreferredSize(new Dimension(120, 45));
        slider.setSnapToTicks(true);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.setLabelTable(this.createLabelTable(0, 100));
        return slider;
    }

    protected Dictionary createLabelTable(int min, int max) {
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        ((Dictionary)labels).put(new Integer(min), new JLabel(Integer.toString(min)));
        ((Dictionary)labels).put(new Integer(max), new JLabel(Integer.toString(max)));
        return labels;
    }

    protected JSlider createSmoothSlider() {
        JSlider slider = this.createSlider();
        return slider;
    }

    protected JLabel createIntervalLabel() {
        return new JLabel(AbstractCommunicationViewerSettingPanel.resource.getString("control_animation_interval"));
    }

    protected JSlider createIntervalSlider() {
        JSlider slider = this.createSlider();
        slider.setMinimum(1);
        slider.setLabelTable(this.createLabelTable(1, 100));
        return slider;
    }

    public AbstractAnimationThread getThread() {
        return this.thread;
    }

    public void setThread(AbstractAnimationThread thread) {
        this.thread = thread;
        this.cEnableCheckBox.setSelected(thread.isEnable());
        this.cLoopCheckBox.setSelected(thread.isLoop());
        this.cSmoothSlider.setValue(thread.getStepCount());
        this.cIntervalSlider.setValue(thread.getInterval());
    }
}

