/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.commviewer.controller;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import jp.ac.keio.sfc.crew.swing.layout.VerticalFlowLayout;
import org.boxed_economy.components.commviewer.CommunicationViewer;
import org.boxed_economy.components.commviewer.controller.AbstractCommunicationViewerSettingPanel;
import org.boxed_economy.components.commviewer.editparts.CommunicationViewerRootEditPart;

public class MainDisplaySettingPanel
extends AbstractCommunicationViewerSettingPanel {
    private JCheckBox cAgentLabelCheckBox;
    private JCheckBox cRelationCheckBox;
    private JCheckBox cRelationLabelCheckBox;
    private JCheckBox cBehaviorCheckBox;
    private JCheckBox cStateCheckBox;

    public MainDisplaySettingPanel(CommunicationViewer viewer) {
        super(viewer);
    }

    protected void initializeComponent() {
        this.setLayout(new VerticalFlowLayout());
    }

    protected void initializeChildComponents() {
        this.cAgentLabelCheckBox = new JCheckBox(AbstractCommunicationViewerSettingPanel.resource.getString("control_display_agent_label"), true);
        this.add(this.cAgentLabelCheckBox);
        this.cAgentLabelCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MainDisplaySettingPanel.this.updateAgentLabelDisplayMode();
            }
        });
        this.cRelationCheckBox = new JCheckBox(AbstractCommunicationViewerSettingPanel.resource.getString("control_display_relation"), true);
        this.add(this.cRelationCheckBox);
        this.cRelationCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MainDisplaySettingPanel.this.updateRelationDisplayMode();
            }
        });
        this.cRelationLabelCheckBox = new JCheckBox(AbstractCommunicationViewerSettingPanel.resource.getString("control_display_relation_label"), true);
        this.add(this.cRelationLabelCheckBox);
        this.cRelationLabelCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MainDisplaySettingPanel.this.updateRelationLabelDisplayMode();
            }
        });
        this.cBehaviorCheckBox = new JCheckBox(AbstractCommunicationViewerSettingPanel.resource.getString("control_display_behavior"), true);
        this.add(this.cBehaviorCheckBox);
        this.cBehaviorCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MainDisplaySettingPanel.this.updateBehaviorDisplayMode();
            }
        });
        this.cStateCheckBox = new JCheckBox(AbstractCommunicationViewerSettingPanel.resource.getString("control_display_state"), true);
        this.add(this.cStateCheckBox);
        this.cStateCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MainDisplaySettingPanel.this.updateStateDisplayMode();
            }
        });
    }

    protected void updateAgentLabelDisplayMode() {
        this.updateDisplayMode(CommunicationViewerRootEditPart.LAYER_AGENT_LABELS, this.cAgentLabelCheckBox);
    }

    protected void updateRelationDisplayMode() {
        this.updateDisplayMode(CommunicationViewerRootEditPart.LAYER_LOWER_CONNECTIONS, this.cRelationCheckBox);
    }

    protected void updateRelationLabelDisplayMode() {
        this.updateDisplayMode(CommunicationViewerRootEditPart.LAYER_RELATION_LABELS, this.cRelationLabelCheckBox);
    }

    protected void updateBehaviorDisplayMode() {
        this.updateDisplayMode(CommunicationViewerRootEditPart.LAYER_UPPER_CONNECTIONS, this.cBehaviorCheckBox);
        this.updateDisplayMode(CommunicationViewerRootEditPart.LAYER_BEHAVIOR_CONTAINERS, this.cBehaviorCheckBox);
    }

    protected void updateStateDisplayMode() {
        this.getRoot().setAllBehaviorStateVisible(this.cStateCheckBox.isSelected());
    }

    private void updateDisplayMode(Object layerConstants, JCheckBox checkbox) {
        Object object = this.getViewer().getEditor().getTreeLock();
        synchronized (object) {
            this.getRoot().getLayer(layerConstants).setVisible(checkbox.isSelected());
        }
    }

    private CommunicationViewerRootEditPart getRoot() {
        return (CommunicationViewerRootEditPart)this.getViewer().getEditor().getRootEditPart();
    }
}

