/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.consecutiveexecuter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.boxed_economy.besp.container.command.ImportWorldCommand;
import org.boxed_economy.besp.container.command.LimitedTimeRunCommand;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.components.consecutiveexecuter.ConsecutiveExecuteThread;
import org.boxed_economy.components.stepclock.StepLimitedTimeRunSetting;

public abstract class ConsecutiveExecuteComponent
extends AbstractInternalFrameComponent
implements SimulationStateListener {
    protected JLabel labelName = new JLabel();
    protected JLabel labelStatus = new JLabel();
    protected JButton buttonRun = new JButton();
    private ConsecutiveExecuteThread thread = null;

    public final void initialize() {
        this.initializeComponents();
        this.initializeThread();
    }

    public final void terminate() {
    }

    private void initializeComponents() {
        this.labelName.setText(this.getTitleName());
        this.buttonRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConsecutiveExecuteComponent.this.thread.doTransitition();
            }
        });
        JPanel north = new JPanel();
        JPanel center = new JPanel();
        JPanel south = new JPanel();
        this.getContentPane().add((Component)north, "North");
        this.getContentPane().add((Component)center, "Center");
        this.getContentPane().add((Component)south, "South");
        north.add(this.labelName);
        center.add(this.buttonRun);
        south.add(this.labelStatus);
    }

    private void initializeThread() {
        this.thread = new ConsecutiveExecuteThread(this);
    }

    protected abstract String getTitleName();

    protected abstract void run() throws InterruptedException;

    protected void showStatusMessage(String message) {
        this.labelStatus.setText(message);
    }

    protected final void executeWorld(Class clazz, long step) {
        try {
            new ImportWorldCommand(this.getPresentationContainer().getContainer(), clazz).execute();
        }
        catch (Exception ex) {
            this.getPresentationContainer().showError("Error in Consecutive Execute", ex);
        }
        this.executeWorld(step);
    }

    protected final void executeWorld(World world, long step) {
        this.getPresentationContainer().getModelContainer().setModel(world);
        this.executeWorld(step);
    }

    private final void executeWorld(long step) {
        try {
            StepLimitedTimeRunSetting newSetting = new StepLimitedTimeRunSetting(step);
            this.getPresentationContainer().getModelContainer().setLimitedRunSetting(newSetting);
            new LimitedTimeRunCommand(this.getPresentationContainer().getContainer()).execute();
            ConsecutiveExecuteComponent consecutiveExecuteComponent = this;
            synchronized (consecutiveExecuteComponent) {
                this.wait();
            }
        }
        catch (Exception ex) {
            this.getPresentationContainer().showError("Error in Consecutive Execute", ex);
        }
    }

    public void simulationStarted(SimulationStateEvent ev) {
    }

    public synchronized void simulationStopped(SimulationStateEvent ev) {
        this.notifyAll();
    }

    public void simulationStopping(SimulationStateEvent ev) {
    }
}

