/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.control;

import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.besp.presentation.bface.menu.Menu;
import org.boxed_economy.besp.presentation.guifw.ShowGUIComponentAction;
import org.boxed_economy.components.control.ControlManagerPlugin;
import org.boxed_economy.components.control.ControlPanel;
import org.boxed_economy.components.control.LimitedTimeRunAction;
import org.boxed_economy.components.control.ResetAction;
import org.boxed_economy.components.control.RunAction;
import org.boxed_economy.components.control.StopAction;

public class ControlManager
extends AbstractPresentationComponent
implements SimulationStateListener,
ModelContainerListener {
    private static final Logger logger;
    public static ResourceBundle resource;
    private ControlPanel controlPanel = null;
    public Menu controlMenu = new Menu();
    public ActionGroup controlGroup = new ActionGroup();
    public Action runAction = new RunAction();
    public Action stopAction = new StopAction();
    public Action stepRunAction = new LimitedTimeRunAction();
    public Action resetAction = new ResetAction();
    public ActionGroup showControlPanelGroup = new ActionGroup();
    public Action showControlPanelAction = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.control.ControlManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        resource = ControlManagerPlugin.resource;
    }

    public void initialize() {
        this.initializeControlPanel();
        this.initializeControlMenu();
        this.initializeShowMenu();
    }

    private void initializeControlPanel() {
        this.controlPanel = new ControlPanel(this);
        this.getPresentationContainer().addPresentationComponent(this.controlPanel);
        this.controlPanel.show();
    }

    private void initializeControlMenu() {
        this.getPresentationContainer().getMenuManager().controlMenuGroup.add(this.controlMenu);
        this.controlMenu.setName(resource.getString("Menu_Control"));
        this.controlMenu.add(this.controlGroup);
        this.controlGroup.add(this.runAction);
        this.controlGroup.add(this.stepRunAction);
        this.controlGroup.add(this.stopAction);
        this.controlGroup.add(this.resetAction);
    }

    private void initializeShowMenu() {
        this.getPresentationContainer().getGuiContainer().showFirstGroup.add(this.showControlPanelGroup);
        this.showControlPanelAction = new ShowGUIComponentAction(resource.getString("Menu_ControlPanel"), this.controlPanel);
        this.showControlPanelGroup.add(this.showControlPanelAction);
    }

    public void terminate() {
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public void simulationStarted(SimulationStateEvent ev) {
        this.runAction.setEnabled(false);
        this.stepRunAction.setEnabled(false);
        this.stopAction.setEnabled(true);
        this.resetAction.setEnabled(false);
    }

    public void simulationStopping(SimulationStateEvent ev) {
        this.stopAction.setEnabled(false);
    }

    public void simulationStopped(SimulationStateEvent ev) {
        this.runAction.setEnabled(true);
        this.stepRunAction.setEnabled(true);
        this.stopAction.setEnabled(false);
        this.resetAction.setEnabled(true);
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
    }

    public void worldOpened(ModelContainerEvent ev) {
        this.runAction.setEnabled(true);
        this.stepRunAction.setEnabled(true);
        this.stopAction.setEnabled(false);
        this.resetAction.setEnabled(true);
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
    }

    public void worldClosed(ModelContainerEvent ev) {
        this.controlGroup.setEnabled(false);
    }
}

