/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.control;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.components.control.ControlManager;
import org.boxed_economy.components.control.ControlManagerPlugin;

public class ControlPanel
extends AbstractInternalFrameComponent
implements SimulationStateListener,
ModelContainerListener {
    private static final Logger logger;
    public static ResourceBundle resource;
    public static final String TITLE;
    public static final String SPACE = " - ";
    public static final String TITLE_RUNNING;
    public static final String TITLE_STOPPING;
    public static final String TITLE_STOPPED;
    public static final String LABEL_NOWORLD;
    public static final String BUTTON_EXTEND;
    private static final int CONTROL_BUTTON_HEIGHT = 40;
    private static final int CONTROL_BUTTON_WIDTH = 40;
    private static final Color CONTROL_BUTTON_BGCOLOR;
    private static final int EXTEND_BUTTON_HEIGHT = 20;
    private static final int EXTEND_BUTTON_WIDTH = 20;
    private ControlManager controlManager = null;
    private boolean isExtended = false;
    private JPanel extendPanel = new JPanel();
    private JLabel labelWorldName = new JLabel();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.control.ControlPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        resource = ControlManagerPlugin.resource;
        TITLE = resource.getString("Title_ControlPanel");
        TITLE_RUNNING = String.valueOf(TITLE) + SPACE + resource.getString("Title_Running");
        TITLE_STOPPING = String.valueOf(TITLE) + SPACE + resource.getString("Title_Stopping");
        TITLE_STOPPED = String.valueOf(TITLE) + SPACE + resource.getString("Title_Stopped");
        LABEL_NOWORLD = resource.getString("Label_NoWorld");
        BUTTON_EXTEND = resource.getString("Button_Extend");
        CONTROL_BUTTON_BGCOLOR = Color.gray;
    }

    public ControlPanel(ControlManager controlManager) {
        this.controlManager = controlManager;
    }

    protected void initializeDefaultCloseOperation() {
        this.setDefaultCloseOperation(1);
    }

    protected void initializeFrame() {
        super.initializeFrame();
    }

    protected void initializeFramePolicy() {
        this.setIconifiable(false);
        this.setClosable(true);
        this.setMaximizable(false);
    }

    protected void initializeIcon() {
        super.initializeIcon();
    }

    public void initialize() {
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().add((Component)this.createWorldNamePanel(), "North");
        this.getContentPane().add((Component)this.createControlButtonPanel(), "Center");
        this.getContentPane().add((Component)this.createExtendButtonPanel(), "East");
        this.worldClosed(null);
        this.initializeSize();
        this.initializeLocation();
    }

    private JPanel createWorldNamePanel() {
        JPanel panel = new JPanel();
        panel.add(this.labelWorldName);
        return panel;
    }

    private JPanel createControlButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.createControlButton(this.controlManager.runAction));
        panel.add(this.createControlButton(this.controlManager.stepRunAction));
        panel.add(this.createControlButton(this.controlManager.stopAction));
        panel.add(this.createControlButton(this.controlManager.resetAction));
        return panel;
    }

    private JButton createControlButton(Action action) {
        JButton button = new JButton(action);
        button.setPreferredSize(new Dimension(40, 40));
        button.setBackground(CONTROL_BUTTON_BGCOLOR);
        button.setText(null);
        button.setIcon(action.getIcon());
        return button;
    }

    private JPanel createExtendButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JButton button = new JButton();
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setText(BUTTON_EXTEND);
        button.setPreferredSize(new Dimension(20, 20));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.transitExtentionState();
            }
        });
        panel.add((Component)button, "South");
        return panel;
    }

    private void initializeSize() {
        this.validate();
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        this.setSize(width, height);
    }

    private void initializeLocation() {
        int wMargin = 50;
        int hMargin = 50;
        int windowWidth = this.getMainFrame().getSize().width;
        int width = this.getSize().width;
        this.setLocation(windowWidth - width - wMargin, hMargin);
    }

    public void terminate() {
    }

    private void transitExtentionState() {
        if (this.isExtended) {
            this.deExtend();
        } else {
            this.extend();
        }
        this.isExtended = !this.isExtended;
    }

    private void extend() {
        this.getContentPane().add((Component)this.extendPanel, "South");
        this.initializeSize();
    }

    private void deExtend() {
        this.getContentPane().remove(this.extendPanel);
        this.initializeSize();
    }

    public void installExtendPanel(JPanel panel) {
        this.extendPanel.add(panel);
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
    }

    public void worldOpened(ModelContainerEvent ev) {
        this.labelWorldName.setText(this.getWorld().getName());
        this.initializeSize();
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
    }

    public void worldClosed(ModelContainerEvent ev) {
        this.labelWorldName.setText(LABEL_NOWORLD);
        this.setTitle(TITLE);
    }

    public void simulationStarted(SimulationStateEvent ev) {
        this.setTitle(TITLE_RUNNING);
    }

    public void simulationStopped(SimulationStateEvent ev) {
        this.setTitle(TITLE_STOPPED);
    }

    public void simulationStopping(SimulationStateEvent ev) {
        this.setTitle(TITLE_STOPPING);
    }
}

