/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.boxed_economy.components.datacollector.DataCollectionContainer;
import org.boxed_economy.components.datacollector.model.fw.AbstractActiveDataCollector;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datacollector.model.fw.DataCollector;
import org.boxed_economy.components.datacollector.model.fw.DataCollectorDescriptor;

public class DataCollectionManager
implements Serializable {
    private transient DataCollectionContainer container = null;
    private transient List descriptors = new ArrayList();
    private List collectors = new ArrayList();

    public DataCollectionContainer getContainer() {
        return this.container;
    }

    public void setContainer(DataCollectionContainer container) {
        if (this.container != container) {
            this.container = container;
            this.initializeActiveDataCollection();
        }
    }

    public void add(DataCollection collection) {
        collection.setManager(this);
        this.collectors.add(collection);
        if (collection.getCollector() instanceof AbstractActiveDataCollector) {
            this.getContainer().getPresentationContainer().addPresentationComponent((AbstractActiveDataCollector)collection.getCollector());
        }
    }

    public void remove(DataCollection collection) {
        this.collectors.remove(collection);
        if (collection.getCollector() instanceof AbstractActiveDataCollector) {
            this.getContainer().getPresentationContainer().removePresentationComponent((AbstractActiveDataCollector)collection.getCollector());
        }
    }

    public List getDataCollections() {
        return new ArrayList(this.collectors);
    }

    public void installDataCollector(DataCollectorDescriptor descriptor) {
        this.getDescriptorsInternal().add(descriptor);
    }

    public List getDescriptors() {
        return new ArrayList(this.getDescriptorsInternal());
    }

    public List getDescriptorsInternal() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList();
        }
        return this.descriptors;
    }

    public DataCollectorDescriptor getDescriptor(DataCollector collector) {
        List descriptors = this.getDescriptorsInternal();
        Iterator i = descriptors.iterator();
        while (i.hasNext()) {
            DataCollectorDescriptor descriptor = (DataCollectorDescriptor)i.next();
            if (!descriptor.getDataCollectorClass().equals(collector.getClass())) continue;
            return descriptor;
        }
        return null;
    }

    private void initializeActiveDataCollection() {
        Iterator i = this.getDataCollections().iterator();
        while (i.hasNext()) {
            DataCollection collection = (DataCollection)i.next();
            if (!(collection.getCollector() instanceof AbstractActiveDataCollector)) continue;
            this.getContainer().getPresentationContainer().addPresentationComponent((AbstractActiveDataCollector)collection.getCollector());
        }
    }
}

