/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.model.collectors;

import java.util.List;
import org.boxed_economy.components.datacollector.model.data.Column;
import org.boxed_economy.components.datacollector.model.data.ColumnList;
import org.boxed_economy.components.datacollector.model.data.DataTable;
import org.boxed_economy.components.datacollector.model.data.Record;
import org.boxed_economy.components.datacollector.model.fw.AbstractDataCollector;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;

public abstract class AbstractCalculateDataCollector
extends AbstractDataCollector {
    private String columnName1 = null;
    private String columnName2 = null;
    static /* synthetic */ Class class$0;

    protected void doCollection(DataTable table) {
        if (!this.isValid()) {
            return;
        }
        List dataList1 = this.getSelectedColumnData(0);
        List dataList2 = this.getSelectedColumnData(1);
        int i = 0;
        while (i < dataList1.size()) {
            double data1 = this.getDoubleValue(dataList1.get(i));
            int j = 0;
            while (j < dataList2.size()) {
                double data2 = this.getDoubleValue(dataList2.get(j));
                this.addData(data1, data2, table);
                ++j;
            }
            ++i;
        }
    }

    private void addData(double data1, double data2, DataTable table) {
        double result = this.calculate(data1, data2);
        Record record = new Record(1);
        record.set(0, new Double(result));
        table.addRecord(record);
    }

    public String getColumnName1() {
        return this.columnName1;
    }

    public void setColumnName1(String columnName) {
        this.columnName1 = columnName;
        this.refreshColumns();
    }

    public String getColumnName2() {
        return this.columnName2;
    }

    public void setColumnName2(String columnName) {
        this.columnName2 = columnName;
        this.refreshColumns();
    }

    public void setColumnName(String columnName, int index) {
        if (index == 0) {
            this.setColumnName1(columnName);
        } else if (index == 1) {
            this.setColumnName2(columnName);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String getColumnName(int index) {
        if (index == 0) {
            return this.getColumnName1();
        }
        if (index == 1) {
            return this.getColumnName2();
        }
        throw new IllegalArgumentException();
    }

    private void refreshColumns() {
        if (!this.isValid()) {
            return;
        }
        ColumnList columns = new ColumnList();
        String string = String.valueOf(this.getColumnName1()) + " " + this.getCalculateSymbol() + " " + this.getColumnName2();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        columns.add(new Column(string, clazz));
        this.setColumns(columns);
    }

    public List getSelectedColumnData(int i) {
        DataCollection source = (DataCollection)this.getDataCollection().getSources().get(i);
        return source.getData().getDataList(this.getColumnName(i));
    }

    protected boolean isValid() {
        try {
            if (this.getDataCollection().getSources().size() == 2) {
                DataCollection source1 = (DataCollection)this.getDataCollection().getSources().get(0);
                source1.getColumns().get(this.columnName1).getName();
                DataCollection source2 = (DataCollection)this.getDataCollection().getSources().get(1);
                source2.getColumns().get(this.columnName2).getName();
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected abstract String getCalculateSymbol();

    protected abstract double calculate(double var1, double var3);

    protected double getDoubleValue(Object value) {
        return this.getNumberValue(value).doubleValue();
    }

    protected Number getNumberValue(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        return new Integer(-1);
    }
}

