/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.model.collectors;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import jp.ac.keio.sfc.crew.refrection.ClassObject;
import org.boxed_economy.components.datacollector.model.argument.Argument;
import org.boxed_economy.components.datacollector.model.collectors.AbstractExtractSelectDataCollector;
import org.boxed_economy.components.datacollector.model.data.Column;
import org.boxed_economy.components.datacollector.model.data.ColumnList;

public class SelectByMethodDataCollector
extends AbstractExtractSelectDataCollector {
    private transient Method method = null;
    private List arguments = new ArrayList();

    protected Object getExtractedData(Object value) {
        try {
            this.method.setAccessible(true);
            return this.method.invoke(value, this.getArgumentValues());
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected Object[] getArgumentValues() {
        Object[] objectArguments = new Object[this.arguments.size()];
        int i = 0;
        while (i < this.arguments.size()) {
            Argument argument = (Argument)this.arguments.get(i);
            objectArguments[i] = argument.getValue();
            ++i;
        }
        return objectArguments;
    }

    public List getArguments() {
        return this.arguments;
    }

    public void setArguments(List objects) {
        this.arguments = objects;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.refreshColumns(method);
        this.refreshArguments();
    }

    private void refreshColumns(Method method) {
        ColumnList columns = new ColumnList(this.getDataCollection().getSource().getColumns());
        columns.add(new Column(method.getName(), method.getReturnType()));
        this.setColumns(columns);
    }

    private void refreshArguments() {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            Argument argument = new Argument(parameterTypes[i]);
            arguments.add(argument);
            ++i;
        }
        this.arguments = arguments;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        ClassObject clazz = this.getTargetColumnType();
        String key = clazz.getMethodKey(this.method);
        s.writeObject(clazz.getType().getName());
        s.writeObject(key);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String clName = (String)s.readObject();
        String key = (String)s.readObject();
        ClassObject.setClassLoader(this.getClass().getClassLoader());
        ClassObject clazz = ClassObject.forName(clName);
        this.method = clazz.getMethod(key);
    }
}

