/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.model.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.boxed_economy.components.datacollector.model.data.Column;
import org.boxed_economy.components.datacollector.model.data.ColumnList;
import org.boxed_economy.components.datacollector.model.data.Record;

public class DataTable {
    private ColumnList columns = null;
    private List records = new ArrayList();

    public DataTable() {
        this.columns = new ColumnList();
    }

    public DataTable(ColumnList columns) {
        this.columns = columns;
    }

    public void addRecord(Record record) {
        this.records.add(record);
    }

    public int size() {
        return this.records.size();
    }

    public List getRecords() {
        return this.records;
    }

    public List getAllDataList() {
        ArrayList<List> allData = new ArrayList<List>();
        int i = 0;
        while (i < this.columns.size()) {
            allData.add(this.getDataList(i));
            ++i;
        }
        return allData;
    }

    public List getDataList(Column column) {
        int columnIndex = this.columns.getIndex(column);
        return this.getDataList(columnIndex);
    }

    public List getDataList(String columnName) {
        int columnIndex = this.columns.getIndex(columnName);
        return this.getDataList(columnIndex);
    }

    public List getDataList(int columnIndex) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        Iterator i = this.records.iterator();
        while (i.hasNext()) {
            Record record = (Record)i.next();
            Object data = record.get(columnIndex);
            dataList.add(data);
        }
        return dataList;
    }

    public Object getData(int rowIndex, String columnName) {
        return this.getData(rowIndex, this.columns.getIndex(columnName));
    }

    public Object getData(int rowIndex, int columnIndex) {
        if (columnIndex < 0 && columnIndex < this.columns.size()) {
            throw new RuntimeException("Illegal Index rowIndex = " + rowIndex + ", columnIndex = " + columnIndex);
        }
        Record record = (Record)this.records.get(rowIndex);
        Object data = record.get(columnIndex);
        return data;
    }

    public void setData(DataTable another) {
        this.setData(another.getAllDataList());
    }

    public void setData(List objectsList) {
        int i = 0;
        while (i < objectsList.size()) {
            this.setData(i, (Collection)objectsList.get(i));
            ++i;
        }
    }

    public void setData(int columnIndex, Collection objects) {
        int rowIndex = 0;
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            this.setData(rowIndex, columnIndex, element);
            ++rowIndex;
        }
    }

    public void setData(int rowIndex, int columnIndex, Object data) {
        if (rowIndex >= this.size()) {
            int createCount = rowIndex - this.size() + 1;
            int i = 0;
            while (i < createCount) {
                this.addRecord(this.createRecord());
                ++i;
            }
        }
        ((Record)this.records.get(rowIndex)).set(columnIndex, data);
    }

    public Record createRecord() {
        return new Record(this.columns.size());
    }

    public void setColumns(ColumnList list) {
        this.columns = list;
    }

    public ColumnList getColumns() {
        return this.columns;
    }
}

