/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.model.fw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.components.datacollector.DataCollectionManager;
import org.boxed_economy.components.datacollector.model.data.ColumnList;
import org.boxed_economy.components.datacollector.model.data.DataTable;
import org.boxed_economy.components.datacollector.model.fw.DataCollector;

public class DataCollection
implements Serializable {
    private static final Logger logger;
    private DataCollectionManager manager;
    private String name = "";
    private List sources = new ArrayList();
    private transient DataTable data = new DataTable();
    private DataCollector collector = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.datacollector.model.fw.DataCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public DataCollection(String name) {
        this.name = name;
    }

    public void update() {
        try {
            int i = 0;
            while (i < this.sources.size()) {
                DataCollection source = (DataCollection)this.sources.get(i);
                source.update();
                ++i;
            }
            this.data = this.collector.doCollection();
        }
        catch (Exception ex) {
            logger.warn((Object)"Exception handled in doCollection", (Throwable)ex);
        }
    }

    public ColumnList getColumns() {
        return this.collector.getColumns();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataTable getData() {
        return this.data;
    }

    public DataCollection getSource() {
        if (this.sources.isEmpty()) {
            return null;
        }
        return (DataCollection)this.sources.get(0);
    }

    public void setSource(DataCollection source) {
        if (source == this) {
            return;
        }
        this.sources.clear();
        this.sources.add(source);
    }

    public List getSources() {
        return new ArrayList(this.sources);
    }

    public void setSources(List sources) {
        if (sources.contains(this)) {
            sources.remove(this);
        }
        this.sources.clear();
        this.sources.addAll(sources);
    }

    public DataCollector getCollector() {
        return this.collector;
    }

    public void setCollector(DataCollector collector) {
        collector.setDataCollection(this);
        this.collector = collector;
    }

    public DataCollectionManager getManager() {
        return this.manager;
    }

    public void setManager(DataCollectionManager manager) {
        this.manager = manager;
    }

    public PresentationContainer getPresentationContainer() {
        return this.manager.getContainer().getPresentationContainer();
    }

    public String toString() {
        return this.getName();
    }
}

