/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.argumentwizard;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.swing.jface.wizard.WizardPage;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.argument.Argument;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datacollector.view.composer.argumentwizard.SelectTypeArgumentFinderWizardPage;

public class SelectArgumentKindWizardPage
extends WizardPage {
    private DataCollection collection;
    private Argument argument;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JCheckBox agentType = new JCheckBox(DCResource.get("SelectArgumentKindWizardPage.Select_AgentType"));
    private JCheckBox goodsType = new JCheckBox(DCResource.get("SelectArgumentKindWizardPage.Select_GoodsType"));
    private JCheckBox informationType = new JCheckBox(DCResource.get("SelectArgumentKindWizardPage.Select_InformationType"));
    private JCheckBox relationType = new JCheckBox(DCResource.get("SelectArgumentKindWizardPage.Select_RelationType"));
    private JCheckBox behaviorType = new JCheckBox(DCResource.get("SelectArgumentKindWizardPage.Select_BehaviorType"));

    public SelectArgumentKindWizardPage(DataCollection collection, Argument argument) {
        this.collection = collection;
        this.argument = argument;
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.setLayout(new VerticalFlowLayout(5));
        this.installCheckBox(this.agentType);
        this.installCheckBox(this.goodsType);
        this.installCheckBox(this.informationType);
        this.installCheckBox(this.relationType);
        this.installCheckBox(this.behaviorType);
    }

    private void installCheckBox(JCheckBox checkbox) {
        this.buttonGroup.add(checkbox);
        this.add(checkbox);
        checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SelectArgumentKindWizardPage.this.getWizard().refreshButtonState();
            }
        });
    }

    public WizardPage getNextWizardPage() {
        if (this.agentType.isSelected()) {
            return new SelectTypeArgumentFinderWizardPage(this.collection, this.argument, 1);
        }
        if (this.goodsType.isSelected()) {
            return new SelectTypeArgumentFinderWizardPage(this.collection, this.argument, 2);
        }
        if (this.informationType.isSelected()) {
            return new SelectTypeArgumentFinderWizardPage(this.collection, this.argument, 3);
        }
        if (this.relationType.isSelected()) {
            return new SelectTypeArgumentFinderWizardPage(this.collection, this.argument, 4);
        }
        if (this.behaviorType.isSelected()) {
            return new SelectTypeArgumentFinderWizardPage(this.collection, this.argument, 5);
        }
        return null;
    }

    public boolean canGoNext() {
        return this.getNextWizardPage() != null;
    }

    public boolean canFinish() {
        return false;
    }

    public void finishPage() {
    }
}

