/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.fw;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.selectors.NumberSelector;
import org.boxed_economy.components.datacollector.model.selectors.ObjectSelector;
import org.boxed_economy.components.datacollector.model.selectors.Selector;
import org.boxed_economy.components.datacollector.model.selectors.StringSelector;
import org.boxed_economy.components.datacollector.model.testers.NumberTester;
import org.boxed_economy.components.datacollector.model.testers.StringTester;
import org.boxed_economy.components.datacollector.model.testers.Tester;

public class SelectorSettingPanel
extends JPanel
implements ItemListener {
    public static final Object NUMBER = new Object();
    public static final Object STRING = new Object();
    public static final Object OBJECT = new Object();
    private Selector selector = null;
    private ButtonGroup group = new ButtonGroup();
    private Map checks = new HashMap();
    private Map checksToKey = new HashMap();
    private Map panels = new HashMap();
    private Map keys = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SelectorSettingPanel() {
        this.initialize();
    }

    public void initialize() {
        this.setLayout(new VerticalFlowLayout());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.datacollector.model.selectors.StringSelector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.installPanel(clazz, STRING, DCResource.get("SelectorSettingPanel.Compare_String"), new StringSelectorPanel());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.boxed_economy.components.datacollector.model.selectors.NumberSelector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.installPanel(clazz2, NUMBER, DCResource.get("SelectorSettingPanel.Compare_Number"), new NumberSelectorPanel());
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.boxed_economy.components.datacollector.model.selectors.ObjectSelector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.installPanel(clazz3, OBJECT, DCResource.get("SelectorSettingPanel.Compare_Object"), new ObjectSelectorPanel());
    }

    public void installPanel(Class clazz, Object key, String title, SelectorPanel panel) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setText(title);
        checkBox.addItemListener(this);
        this.group.add(checkBox);
        this.checks.put(key, checkBox);
        this.panels.put(key, panel);
        this.keys.put(clazz, key);
        this.checksToKey.put(checkBox, key);
        this.add(checkBox);
        this.add(panel);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            JCheckBox checkBox = (JCheckBox)e.getItem();
            Object key = this.getKey(checkBox);
            SelectorPanel panel = this.getPanel(key);
            Selector selector = panel.getSelector();
            this.setSelectedSelector(selector);
        }
    }

    public void setSelectedSelector(Selector selector) {
        this.selector = selector;
        this.updateSelectedSelector();
    }

    private void updateSelectedSelector() {
        Object key = this.getKey(this.selector);
        SelectorPanel panel = this.getPanel(key);
        panel.setSelector(this.selector);
        panel.updateFromModel();
        JCheckBox check = this.getCheckBox(key);
        check.setSelected(true);
        this.activatePanel(panel);
    }

    public Selector getSelectedSelector() {
        Object key = this.getKey(this.selector);
        SelectorPanel panel = this.getPanel(key);
        panel.updateFromView();
        return this.selector;
    }

    private void activatePanel(SelectorPanel panel) {
        Iterator i = this.panels.values().iterator();
        while (i.hasNext()) {
            JPanel each = (JPanel)i.next();
            if (each == panel) {
                each.setEnabled(true);
                continue;
            }
            each.setEnabled(false);
        }
    }

    private Object getKey(Selector selector) {
        return this.keys.get(selector.getClass());
    }

    private Object getKey(JCheckBox checkBox) {
        return this.checksToKey.get(checkBox);
    }

    private SelectorPanel getPanel(Object key) {
        return (SelectorPanel)this.panels.get(key);
    }

    private JCheckBox getCheckBox(Object key) {
        return (JCheckBox)this.checks.get(key);
    }

    abstract class SelectorPanel
    extends JPanel
    implements ItemListener {
        private Selector selector = null;
        private JComboBox comboBox = new JComboBox();

        SelectorPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.selector = this.createSelector();
            this.initializeComboBox(this.comboBox);
            this.comboBox.setPreferredSize(new Dimension(100, 23));
            this.hook();
            this.add(this.comboBox);
        }

        protected abstract Selector createSelector();

        protected abstract void initializeComboBox(JComboBox var1);

        protected abstract void doUpdateFromView();

        protected abstract void doUpdateFromModel();

        public void updateFromView() {
            this.unhook();
            this.doUpdateFromView();
            this.hook();
        }

        public void updateFromModel() {
            this.unhook();
            this.doUpdateFromModel();
            this.hook();
        }

        public void itemStateChanged(ItemEvent e) {
            this.updateFromView();
        }

        public Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Selector selector) {
            this.selector = selector;
        }

        public JComboBox getComboBox() {
            return this.comboBox;
        }

        protected Object getSelectedItem() {
            return this.comboBox.getSelectedItem();
        }

        protected void setSelectedItem(Object object) {
            this.comboBox.setSelectedItem(object);
        }

        protected void hook() {
            this.comboBox.addItemListener(this);
        }

        protected void unhook() {
            this.comboBox.removeItemListener(this);
        }

        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            int len = this.getComponentCount();
            int i = 0;
            while (i < len) {
                this.getComponent(i).setEnabled(enable);
                ++i;
            }
        }
    }

    class StringSelectorPanel
    extends SelectorPanel {
        private JTextField textField;

        StringSelectorPanel() {
        }

        protected void initialize() {
            this.textField = new JTextField();
            this.textField.setPreferredSize(new Dimension(100, 23));
            this.add(this.textField);
            super.initialize();
        }

        protected Selector createSelector() {
            return new StringSelector();
        }

        protected void initializeComboBox(JComboBox comboBox) {
            comboBox.addItem(Tester.EQUALS_STRING);
            comboBox.addItem(Tester.INCLUDES_STRING);
        }

        public void doUpdateFromView() {
            StringSelector selector = (StringSelector)this.getSelector();
            selector.setTester((StringTester)this.getSelectedItem());
            selector.setString(this.textField.getText());
        }

        public void doUpdateFromModel() {
            StringSelector selector = (StringSelector)this.getSelector();
            this.setSelectedItem(selector.getTester());
            this.textField.setText(selector.getString());
        }
    }

    class NumberSelectorPanel
    extends SelectorPanel {
        private JFormattedTextField textField;

        NumberSelectorPanel() {
        }

        protected void initialize() {
            this.add(new JLabel(DCResource.get("SelectorSettingPanel.Each")));
            super.initialize();
            this.textField = new JFormattedTextField(new DecimalFormat());
            this.textField.setPreferredSize(new Dimension(100, 23));
            this.add(this.textField);
        }

        protected Selector createSelector() {
            return new NumberSelector();
        }

        protected void initializeComboBox(JComboBox comboBox) {
            comboBox.addItem(Tester.EQUALS_NUMBER);
            comboBox.addItem(Tester.NOTEQUALS_NUMBER);
            comboBox.addItem(Tester.GREATER_NUMBER);
            comboBox.addItem(Tester.GREATEROREQUALS_NUMBER);
            comboBox.addItem(Tester.LESS_NUMBER);
            comboBox.addItem(Tester.LESSOREQUALS_NUMBER);
        }

        public void doUpdateFromView() {
            NumberSelector selector = (NumberSelector)this.getSelector();
            selector.setTester((NumberTester)this.getSelectedItem());
            selector.setNumber(Double.parseDouble(this.textField.getText()));
        }

        public void doUpdateFromModel() {
            NumberSelector selector = (NumberSelector)this.getSelector();
            this.setSelectedItem(selector.getTester());
            this.textField.setText(selector.getNumber().toString());
        }
    }

    class ObjectSelectorPanel
    extends SelectorPanel {
        private String ISNULL = "";
        private String ISNOTNULL = "";

        ObjectSelectorPanel() {
        }

        protected Selector createSelector() {
            return new ObjectSelector();
        }

        protected void initializeComboBox(JComboBox comboBox) {
            this.ISNULL = DCResource.get("SelectorSettingPanel.Is_Null");
            this.ISNOTNULL = DCResource.get("SelectorSettingPanel.Is_Not_Null");
            comboBox.addItem(this.ISNULL);
            comboBox.addItem(this.ISNOTNULL);
        }

        public void doUpdateFromView() {
            ObjectSelector instance = (ObjectSelector)this.getSelector();
            if (this.getSelectedItem() == this.ISNULL) {
                instance.setNull(true);
            } else {
                instance.setNull(false);
            }
        }

        public void doUpdateFromModel() {
            ObjectSelector instance = (ObjectSelector)this.getSelector();
            if (instance.isNull()) {
                this.setSelectedItem(this.ISNULL);
            } else {
                this.setSelectedItem(this.ISNOTNULL);
            }
        }
    }
}

