/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.panels;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.collectors.AbstractCalculateDataCollector;
import org.boxed_economy.components.datacollector.model.data.Column;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datacollector.view.composer.fw.AbstractDataCollectorComposePanel;

public class CalcurateDataCollectorComposePanel
extends AbstractDataCollectorComposePanel {
    private JComboBox[] comboBox = new JComboBox[2];

    public CalcurateDataCollectorComposePanel() {
        this.comboBox[0] = new JComboBox();
        this.comboBox[1] = new JComboBox();
    }

    public void initialize() {
        this.setLayout(new VerticalFlowLayout());
        this.sourceUpdated();
        this.comboBox[0].addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CalcurateDataCollectorComposePanel.this.setColumn(0);
            }
        });
        this.comboBox[1].addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CalcurateDataCollectorComposePanel.this.setColumn(1);
            }
        });
        JPanel titledColumnSelection = this.createResizedTitledPanel(DCResource.get("CalcurateDataCollectorComposePanel.Column1"), this.comboBox[0]);
        this.add(titledColumnSelection);
        titledColumnSelection = this.createResizedTitledPanel(DCResource.get("CalcurateDataCollectorComposePanel.Column2"), this.comboBox[1]);
        this.add(titledColumnSelection);
    }

    public void sourceUpdated() {
        this.refreshComboBox(0);
        this.refreshComboBox(1);
        this.setSelection(0);
        this.setSelection(1);
        this.setColumn(0);
        this.setColumn(1);
    }

    private void refreshComboBox(int i) {
        if (this.getDataCollection().getSources().size() == 2) {
            DataCollection source = (DataCollection)this.getDataCollection().getSources().get(i);
            this.comboBox[i].removeAllItems();
            this.addItems(this.comboBox[i], source.getColumns().getAsList());
        }
    }

    protected void setSelection(int i) {
        Column col;
        String colName = this.getCalculateDataCollector().getColumnName(i);
        if (colName != null && (col = this.getDataCollection().getSource().getColumns().get(colName)) != null) {
            this.comboBox[i].setSelectedItem(col);
        }
    }

    protected void setColumn(int i) {
        Object selectedItem = this.comboBox[i].getSelectedItem();
        if (selectedItem instanceof Column) {
            Column column = (Column)selectedItem;
            this.getCalculateDataCollector().setColumnName(column.getName(), i);
        }
    }

    protected AbstractCalculateDataCollector getCalculateDataCollector() {
        return (AbstractCalculateDataCollector)this.getDataCollector();
    }
}

