/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.panels;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datacollector.view.composer.fw.AbstractDataSourceSelectionPanel;
import org.boxed_economy.components.datacollector.view.composer.fw.DataSourceSelectionPanel;

public class DoubleDataSourceSelectionPanel
extends AbstractDataSourceSelectionPanel
implements DataSourceSelectionPanel {
    private JComboBox[] comboBox = new JComboBox[2];

    public DoubleDataSourceSelectionPanel() {
        this.comboBox[0] = new JComboBox();
        this.comboBox[1] = new JComboBox();
    }

    public void initialize() {
        this.setLayout(new VerticalFlowLayout());
        this.initializeComboBoxForDataCollection(this.comboBox[0]);
        this.initializeComboBoxForDataCollection(this.comboBox[1]);
        this.comboBox[0].addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DoubleDataSourceSelectionPanel.this.notifyChangeToParent();
            }
        });
        this.comboBox[1].addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DoubleDataSourceSelectionPanel.this.notifyChangeToParent();
            }
        });
        JPanel titled = this.createResizedTitledPanel(DCResource.get("DoubleDataSourceSelectionPanel.Source1"), this.comboBox[0]);
        this.add(titled);
        titled = this.createResizedTitledPanel(DCResource.get("DoubleDataSourceSelectionPanel.Source2"), this.comboBox[1]);
        this.add(titled);
    }

    private void notifyChangeToParent() {
        this.getParentEditPanel().updateSource();
    }

    public void setSelectedDataCollection(DataCollection collection, int i) {
        this.comboBox[i].setSelectedItem(collection);
    }

    public DataCollection getSelectedDataCollection(int i) {
        return (DataCollection)this.comboBox[i].getSelectedItem();
    }

    public List getSelectedDataCollections() {
        ArrayList<DataCollection> selectedDataCollections = new ArrayList<DataCollection>();
        selectedDataCollections.add(this.getSelectedDataCollection(0));
        selectedDataCollections.add(this.getSelectedDataCollection(1));
        return selectedDataCollections;
    }

    public void setSelectedDataCollections(List selectedDataCollections, int i) {
        if (!selectedDataCollections.isEmpty()) {
            this.setSelectedDataCollection((DataCollection)selectedDataCollections.get(i), i);
        } else {
            this.notifyChangeToParent();
        }
    }

    public void setSelectedDataCollections(List selectedDataCollections) {
        this.setSelectedDataCollections(selectedDataCollections, 0);
        this.setSelectedDataCollections(selectedDataCollections, 1);
    }
}

