/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.panels;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.ac.keio.sfc.crew.refrection.ClassObject;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.collectors.FieldSelectDataCollector;
import org.boxed_economy.components.datacollector.view.composer.panels.ColumnSelectDataCollectorComposePanel;

public class FieldSelectDataCollectorComposePanel
extends ColumnSelectDataCollectorComposePanel
implements DocumentListener,
ItemListener {
    private JTextField textField = new JTextField();
    private JComboBox comboBox = new JComboBox();

    public void initialize() {
        super.initialize();
        this.comboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((Field)value).getName());
                }
                return this;
            }
        });
        JPanel titledFieldSelection = this.createResizedTitledPanel(DCResource.get("FieldSelectDataCollectorComposePanel.Field"), this.textField);
        this.add(titledFieldSelection);
        titledFieldSelection = this.createResizedTitledPanel(DCResource.get("FieldSelectDataCollectorComposePanel.FieldList"), this.comboBox);
        this.add(titledFieldSelection);
    }

    public void setColumn() {
        super.setColumn();
        this.comboBox.removeItemListener(this);
        this.initializeComboBox();
        this.setComboBoxSelection();
        String fieldName = this.getFieldSelectDataCollector().getFieldName();
        this.setFieldText(fieldName);
        this.comboBox.addItemListener(this);
    }

    private void initializeComboBox() {
        if (this.getDataCollection().getSource() != null) {
            this.comboBox.removeAllItems();
            this.addItems(this.comboBox, new ArrayList(this.getFields().values()));
        }
    }

    private void setComboBoxSelection() {
        Field field;
        String fieldName = this.getFieldSelectDataCollector().getFieldName();
        if (fieldName != null && (field = (Field)this.getFields().get(fieldName)) != null) {
            this.comboBox.setSelectedItem(field);
        }
    }

    public Map getFields() {
        try {
            LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
            String colName = this.getFieldSelectDataCollector().getColumnName();
            Class type = this.getDataCollection().getSource().getColumns().get(colName).getType();
            List fields = ClassObject.lookup(type).getFields(136);
            int i = 0;
            while (i < fields.size()) {
                Field field = (Field)fields.get(i);
                fieldMap.put(field.getName(), field);
                ++i;
            }
            return fieldMap;
        }
        catch (Exception ex) {
            return new LinkedHashMap();
        }
    }

    private void setFieldByComboBox() {
        Object selectedItem = this.comboBox.getSelectedItem();
        if (selectedItem instanceof Field) {
            Field field = (Field)selectedItem;
            this.setFieldText(field.getName());
            this.getFieldSelectDataCollector().setFieldName(this.textField.getText());
        }
    }

    protected FieldSelectDataCollector getFieldSelectDataCollector() {
        return (FieldSelectDataCollector)this.getDataCollector();
    }

    private void setFieldText(String text) {
        this.textField.getDocument().removeDocumentListener(this);
        this.textField.setText(text);
        this.textField.getDocument().addDocumentListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        this.setFieldByComboBox();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.getFieldSelectDataCollector().setFieldName(this.textField.getText());
    }

    public void removeUpdate(DocumentEvent e) {
        this.getFieldSelectDataCollector().setFieldName(this.textField.getText());
    }
}

