/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import jp.ac.keio.sfc.crew.swing.jface.list.ElementChooser;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datacollector.view.composer.fw.AbstractDataSourceSelectionPanel;
import org.boxed_economy.components.datacollector.view.composer.fw.DataSourceSelectionPanel;

public class MultipleDataSourceSelectionPanel
extends AbstractDataSourceSelectionPanel
implements DataSourceSelectionPanel {
    private List selectedDataCollections = new ArrayList();
    private JLabel label = new JLabel();
    private JButton button = new JButton();

    public void initialize() {
        this.label.setPreferredSize(new Dimension(100, 27));
        this.add(this.label);
        this.button.setText(DCResource.get("MultipleDataSourceSelectionPanel.Choose"));
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultipleDataSourceSelectionPanel.this.chooseCollectors();
            }
        });
        this.add(this.button);
    }

    private void chooseCollectors() {
        List allDataCollections = this.getManager().getDataCollections();
        List result = ElementChooser.open(this.getPresentationContainer().getMainFrame(), allDataCollections, this.selectedDataCollections, DCResource.get("MultipleDataSourceSelectionPanel.Selection"), DCResource.get("MultipleDataSourceSelectionPanel.Instruction"), DCResource.get("MultipleDataSourceSelectionPanel.Removed"), DCResource.get("MultipleDataSourceSelectionPanel.Added"));
        if (result != null) {
            this.selectedDataCollections = result;
            this.getParentEditPanel().updateSource();
        }
        this.updateLabelString();
    }

    private void updateLabelString() {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.selectedDataCollections.iterator();
        while (i.hasNext()) {
            DataCollection collection = (DataCollection)i.next();
            buf.append(collection.getName());
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        this.label.setText(buf.toString());
    }

    public void setSelectedDataCollections(List dataCollections) {
        this.selectedDataCollections = dataCollections;
        this.updateLabelString();
    }

    public List getSelectedDataCollections() {
        return this.selectedDataCollections;
    }
}

