/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.panels;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datacollector.view.composer.fw.AbstractDataSourceSelectionPanel;
import org.boxed_economy.components.datacollector.view.composer.fw.DataSourceSelectionPanel;

public class SingleDataSourceSelectionPanel
extends AbstractDataSourceSelectionPanel
implements DataSourceSelectionPanel {
    private JComboBox comboBox = new JComboBox();

    public void initialize() {
        this.initializeComboBoxForDataCollection(this.comboBox);
        this.comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SingleDataSourceSelectionPanel.this.notifyChangeToParent();
            }
        });
        JPanel titled = this.createResizedTitledPanel(DCResource.get("SingleDataSourceSelectionPanel.Source"), this.comboBox);
        this.add(titled);
    }

    private void notifyChangeToParent() {
        this.getParentEditPanel().updateSource();
    }

    public void setSelectedDataCollection(DataCollection collection) {
        this.comboBox.setSelectedItem(collection);
    }

    public DataCollection getSelectedDataCollection() {
        return (DataCollection)this.comboBox.getSelectedItem();
    }

    public List getSelectedDataCollections() {
        ArrayList<DataCollection> selectedDataCollections = new ArrayList<DataCollection>();
        selectedDataCollections.add(this.getSelectedDataCollection());
        return selectedDataCollections;
    }

    public void setSelectedDataCollections(List selectedDataCollections) {
        if (!selectedDataCollections.isEmpty()) {
            this.setSelectedDataCollection((DataCollection)selectedDataCollections.get(0));
        } else {
            this.notifyChangeToParent();
        }
    }
}

