/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.panels;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.collectors.TradeDescriptionDataCollector;
import org.boxed_economy.components.datacollector.view.composer.fw.AbstractDataCollectorComposePanel;
import org.boxed_economy.components.datacollector.view.composer.typechoosewizard.SelectGoodsTypeWizard;

public class TradeDescriptionDataCollectorComposePanel
extends AbstractDataCollectorComposePanel
implements DocumentListener {
    private JFormattedTextField intervalTextField = new JFormattedTextField(new DecimalFormat());
    private JLabel measureTypeLabel = new JLabel("");
    private JLabel targetTypeLabel = new JLabel("");
    private JButton measureTypeChooseButton = new JButton(DCResource.get("TradeDescriptionDataCollectorComposePanel.Select"));
    private JButton targetTypeChooseButton = new JButton(DCResource.get("TradeDescriptionDataCollectorComposePanel.Select"));

    public void initialize() {
        this.setLayout(new VerticalFlowLayout());
        this.measureTypeChooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TradeDescriptionDataCollectorComposePanel.this.selectType(1);
            }
        });
        this.targetTypeChooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TradeDescriptionDataCollectorComposePanel.this.selectType(2);
            }
        });
        JPanel titledFieldSelection = this.createResizedTitledPanel(DCResource.get("TradeDescriptionDataCollectorComposePanel.Source_GoodsType"), this.measureTypeLabel);
        this.add(titledFieldSelection);
        titledFieldSelection = this.createResizedTitledPanel("", this.measureTypeChooseButton);
        this.add(titledFieldSelection);
        titledFieldSelection = this.createResizedTitledPanel(DCResource.get("TradeDescriptionDataCollectorComposePanel.Target_GoodsType"), this.targetTypeLabel);
        this.add(titledFieldSelection);
        titledFieldSelection = this.createResizedTitledPanel("", this.targetTypeChooseButton);
        this.add(titledFieldSelection);
        titledFieldSelection = this.createResizedTitledPanel(DCResource.get("TradeDescriptionDataCollectorComposePanel.Interval"), this.intervalTextField);
        this.add(titledFieldSelection);
        this.refreshLabels();
    }

    private void selectType(int rollType) {
        SelectGoodsTypeWizard wizard = new SelectGoodsTypeWizard((Frame)this.getPresentationContainer().getMainFrame(), this.getDataCollection(), rollType);
        wizard.show();
        this.refreshLabels();
    }

    private void refreshLabels() {
        String measureTypeName = this.getGoodsTypeName(this.getTradeDescriptionDataCollector().getMeasureGoodsType());
        this.measureTypeLabel.setText(measureTypeName);
        String targetTypeName = this.getGoodsTypeName(this.getTradeDescriptionDataCollector().getTargetGoodsType());
        this.targetTypeLabel.setText(targetTypeName);
        this.intervalTextField.getDocument().removeDocumentListener(this);
        int interval = this.getTradeDescriptionDataCollector().getStepInterval();
        this.intervalTextField.setText(Integer.toString(interval));
        this.intervalTextField.getDocument().addDocumentListener(this);
    }

    private String getGoodsTypeName(GoodsType goodsType) {
        if (goodsType == GoodsType.NULL) {
            return DCResource.get("TradeDescriptionDataCollectorComposePanel.Not_Assigned");
        }
        String measureTypeName = goodsType.getName();
        return measureTypeName;
    }

    public void sourceUpdated() {
    }

    protected TradeDescriptionDataCollector getTradeDescriptionDataCollector() {
        return (TradeDescriptionDataCollector)this.getDataCollector();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.setInterval();
    }

    public void removeUpdate(DocumentEvent e) {
        this.setInterval();
    }

    private void setInterval() {
        try {
            int newInterval = Integer.parseInt(this.intervalTextField.getText());
            this.getTradeDescriptionDataCollector().setStepInterval(newInterval);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

