/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.swing.jface.list.ListPanel;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datacollector.view.composer.fw.DataCollectionComposer;
import org.boxed_economy.components.datacollector.view.manager.AbstractDataCollectionManagementPanel;
import org.boxed_economy.components.datacollector.view.viewer.DataCollectionViewerFrame;

public class DataCollectionManagementPanel
extends AbstractDataCollectionManagementPanel {
    private ListPanel collectionsPanel = new ListPanel();
    private JPanel buttonsPanel = new JPanel();
    private JButton createButton = new JButton();
    private JButton editButton = new JButton();
    private JButton removeButton = new JButton();
    private JButton showButton = new JButton();

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.initializeCollectionsPanel();
        this.initializeButtonsPanel();
        this.add((Component)this.buttonsPanel, "East");
        this.add((Component)this.collectionsPanel, "Center");
    }

    private void initializeCollectionsPanel() {
        this.collectionsPanel.getJList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataCollectionManagementPanel.this.buttonStateUpdate();
            }
        });
        this.updateCollectionsPanel();
    }

    private void initializeButtonsPanel() {
        this.buttonsPanel.setLayout(new VerticalFlowLayout());
        this.createButton.setText(DCResource.get("DataCollectionManagementPanel.Create"));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataCollectionManagementPanel.this.doCreate();
            }
        });
        this.buttonsPanel.add(this.createButton);
        this.editButton.setText(DCResource.get("DataCollectionManagementPanel.Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataCollectionManagementPanel.this.doEdit();
            }
        });
        this.buttonsPanel.add(this.editButton);
        this.showButton.setText(DCResource.get("DataCollectionManagementPanel.Show"));
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataCollectionManagementPanel.this.doShow();
            }
        });
        this.buttonsPanel.add(this.showButton);
        this.removeButton.setText(DCResource.get("DataCollectionManagementPanel.Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataCollectionManagementPanel.this.doRemove();
            }
        });
        this.buttonsPanel.add(this.removeButton);
        this.buttonStateUpdate();
    }

    private void buttonStateUpdate() {
        Object[] objects = this.collectionsPanel.getJList().getSelectedValues();
        if (objects.length > 0) {
            this.removeButton.setEnabled(true);
            this.showButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.showButton.setEnabled(false);
        }
        if (objects.length == 1) {
            this.editButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
        }
    }

    private void doShow() {
        Object[] objects = this.collectionsPanel.getJList().getSelectedValues();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof DataCollection) {
                this.showViewer((DataCollection)objects[i]);
            }
            ++i;
        }
    }

    private void doCreate() {
        DataCollectionComposer.createOpen(this.getPresentationContainer(), this.getManager());
        this.updateCollectionsPanel();
    }

    private void doEdit() {
        Object collection = this.collectionsPanel.getJList().getSelectedValue();
        DataCollectionComposer.editOpen(this.getPresentationContainer(), this.getManager(), (DataCollection)collection);
        this.updateCollectionsPanel();
    }

    private void doRemove() {
        Object[] objects = this.collectionsPanel.getJList().getSelectedValues();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof DataCollection) {
                this.getManager().remove((DataCollection)objects[i]);
            }
            ++i;
        }
        this.updateCollectionsPanel();
    }

    private void showViewer(DataCollection collection) {
        DataCollectionViewerFrame viewer = new DataCollectionViewerFrame(collection);
        this.getPresentationContainer().addPresentationComponent(viewer);
        viewer.show();
    }

    private void updateCollectionsPanel() {
        this.collectionsPanel.setList(this.getManager().getDataCollections());
    }
}

