/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datapresentation.DataPresentationComponent;

public abstract class AbstractDataPresentationComponent
extends AbstractPresentationComponent
implements DataPresentationComponent,
ModelContainerListener,
UpdateClockListener,
Serializable {
    private transient boolean initialized = false;
    private transient boolean active = false;
    private List dataCollections = new ArrayList();
    private int stepInterval = 1;
    private transient int stepCount = 0;

    public void initialize() {
    }

    public void terminate() {
    }

    public final boolean isActive() {
        return this.active;
    }

    public final void setActive(boolean active) {
        if (!this.active && active) {
            this.active = true;
            this.activate();
        }
        if (this.active && !active) {
            this.deActivate();
            this.active = false;
        }
    }

    public void activate() {
        this.addUpdateClockListener(this);
        this.prepareWorldOpen(null);
    }

    public void deActivate() {
        this.removeUpdateClockListener(this);
        this.worldClosed(null);
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public List getDataCollections() {
        return new ArrayList(this.dataCollections);
    }

    public void setDataCollections(List list) {
        this.dataCollections = list;
    }

    public int getStepInterval() {
        return this.stepInterval;
    }

    public void setStepInterval(int interval) {
        this.stepInterval = interval;
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
        if (this.isInitializable()) {
            this.initializeWorldSkelton();
        }
    }

    public void worldOpened(ModelContainerEvent ev) {
        if (this.isInitializable()) {
            this.initializeWorldSkelton();
        }
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
        if (this.initialized) {
            this.terminateWorldSkelton();
        }
    }

    public void worldClosed(ModelContainerEvent ev) {
        if (this.initialized) {
            this.terminateWorldSkelton();
        }
    }

    public void clockGained(UpdateClockEvent e) {
        if (this.isRunning()) {
            this.stepSkelton();
        }
    }

    private boolean isRunning() {
        return this.initialized && this.isActive() && this.getWorld() != null;
    }

    private boolean isInitializable() {
        return !this.initialized && this.isActive() && this.getWorld() != null;
    }

    protected void stepSkelton() {
        ++this.stepCount;
        if (this.stepCount == this.stepInterval) {
            this.updateAllDataCollections();
            this.step();
            this.stepCount = 0;
        }
    }

    protected void updateAllDataCollections() {
        int i = 0;
        while (i < this.dataCollections.size()) {
            DataCollection dataCollection = (DataCollection)this.dataCollections.get(i);
            dataCollection.update();
            ++i;
        }
    }

    protected abstract void step();

    protected void initializeWorldSkelton() {
        this.stepCount = 0;
        this.initializeWorld();
        this.initialized = true;
    }

    protected abstract void initializeWorld();

    protected void terminateWorldSkelton() {
        this.stepCount = 0;
        this.terminateWorld();
        this.initialized = false;
    }

    protected abstract void terminateWorld();
}

