/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.components.datacollector.model.data.Record;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datapresentation.AbstractDataPresentationComponent;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.graph.model.Axis;
import org.boxed_economy.components.datapresentation.graph.model.SimpleGraphModel;
import org.boxed_economy.components.datapresentation.graph.model.Unit;
import org.boxed_economy.components.stepclock.StepClock;

public class GraphComponent
extends AbstractDataPresentationComponent {
    private String name = "Default Graph Data";
    private transient List graphModels = new ArrayList();
    private transient int dataCount;

    public void initialize() {
    }

    public void terminate() {
    }

    public List getGraphModels() {
        return this.graphModels;
    }

    public void setDataCollections(List list) {
        super.setDataCollections(list);
        this.createGraphModels();
    }

    protected void initializeWorld() {
        this.createGraphModel();
    }

    protected void terminateWorld() {
    }

    protected void step() {
        this.writeData();
    }

    private void createGraphModel() {
        this.dataCount = 0;
        this.initializeGraphModels();
    }

    private void initializeGraphModels() {
        int i = 0;
        while (i < this.graphModels.size()) {
            SimpleGraphModel graphModel = (SimpleGraphModel)this.graphModels.get(i);
            graphModel.clear();
            ++i;
        }
    }

    private void createGraphModels() {
        this.graphModels.clear();
        List dataCollections = this.getDataCollections();
        int i = 0;
        while (i < dataCollections.size()) {
            DataCollection dataCollection = (DataCollection)dataCollections.get(i);
            this.createOneGraphModel(dataCollection);
            ++i;
        }
    }

    private void createOneGraphModel(DataCollection dataCollection) {
        Axis x = new Axis(DPResource.get("GraphComponent.Time"), new Unit(DPResource.get("GraphComponent.Step")));
        Axis y = new Axis(dataCollection.getName(), new Unit(dataCollection.getColumns().get(0).toString()));
        SimpleGraphModel graphModel = new SimpleGraphModel(dataCollection.getName(), x, y);
        this.graphModels.add(graphModel);
    }

    private synchronized void writeData() {
        int i = 0;
        while (i < this.graphModels.size()) {
            SimpleGraphModel graphModel = (SimpleGraphModel)this.graphModels.get(i);
            DataCollection dataCollection = (DataCollection)this.getDataCollections().get(i);
            this.writeOneData(dataCollection, graphModel);
            ++i;
        }
    }

    private void writeOneData(DataCollection dataCollection, SimpleGraphModel graphModel) {
        double value = 0.0;
        try {
            Record firstRecord = (Record)dataCollection.getData().getRecords().get(0);
            int size = firstRecord.size();
            int i = 0;
            while (i < size) {
                Object o = firstRecord.get(i);
                if (o instanceof Number) {
                    value = ((Number)o).doubleValue();
                    break;
                }
                ++i;
            }
        }
        catch (Exception firstRecord) {
            // empty catch block
        }
        Point2D.Double p = new Point2D.Double(this.getStep(), value);
        graphModel.addPoint(p);
    }

    private long getStep() {
        Clock clock = this.getWorld().getClock();
        if (clock instanceof StepClock) {
            return ((StepClock)clock).getStep();
        }
        return this.dataCount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return String.valueOf(this.name) + "  --  " + this.getActiveString();
    }

    private String getActiveString() {
        if (this.isActive()) {
            return DPResource.get("GraphComponent.active");
        }
        return DPResource.get("GraphComponent.inactive");
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.graphModels = new ArrayList();
        this.createGraphModels();
    }
}

