/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.legacy.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.components.datapresentation.graph.legacy.viewer.MultiGraphView;

public class MultiGraphGuiComponent
extends AbstractInternalFrameComponent
implements UpdateClockListener,
ModelContainerListener {
    private JScrollPane scrollPanel = new JScrollPane();
    private MultiGraphView view = new MultiGraphView();
    private JPanel settingPanel = new JPanel(new GridLayout(3, 1));
    private JPanel scaleSettingPanel = new JPanel();
    private JTextField xMarginText = new JTextField();
    private JTextField yMarginText = new JTextField();
    private JButton scaleSettingButton = new JButton("\u5909\u66f4");
    private JPanel gridSettingPanel = new JPanel();
    private JRadioButton gridTrue = new JRadioButton();
    private JRadioButton gridFalse = new JRadioButton();
    private JButton zoomInButton = new JButton("Zoom In");
    private JButton zoomOutButton = new JButton("Zoom Out");

    public void initialize() {
        this.setSize(700, 550);
        this.setTitle("GraphWindow");
        this.getContentPane().setLayout(new BorderLayout());
        this.scrollPanel.getViewport().add(this.view);
        this.getContentPane().add((Component)this.scrollPanel, "Center");
        this.scaleSettingPanel.add(this.zoomInButton);
        this.scaleSettingPanel.add(this.zoomOutButton);
        this.scaleSettingPanel.add(new JLabel(" x\u8ef8\uff1a"));
        this.xMarginText.setText(Double.toString(this.view.getGraphSetting().xScale));
        this.scaleSettingPanel.add(this.xMarginText);
        this.scaleSettingPanel.add(new JLabel("(pixel/1\u5358\u4f4d)"));
        this.scaleSettingPanel.add(new JLabel(" y\u8ef8\uff1a"));
        this.yMarginText.setText(Double.toString(this.view.getGraphSetting().yScale));
        this.scaleSettingPanel.add(this.yMarginText);
        this.scaleSettingPanel.add(new JLabel("(pixel/1\u5358\u4f4d)"));
        this.scaleSettingPanel.add(this.scaleSettingButton);
        this.settingPanel.add(this.scaleSettingPanel);
        this.gridSettingPanel.add(this.gridTrue);
        this.gridSettingPanel.add(this.gridFalse);
        this.gridTrue.setText("\u30b0\u30ea\u30c3\u30c9\u8868\u793a");
        this.gridTrue.setSelected(this.view.getGraphSetting().isWriteHorizonalGrid);
        this.gridFalse.setText("\u30b0\u30ea\u30c3\u30c9\u975e\u8868\u793a");
        this.gridFalse.setSelected(!this.view.getGraphSetting().isWriteHorizonalGrid);
        ButtonGroup group = new ButtonGroup();
        group.add(this.gridTrue);
        group.add(this.gridFalse);
        this.settingPanel.add(this.gridSettingPanel);
        this.getContentPane().add((Component)this.settingPanel, "South");
        this.scaleSettingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiGraphGuiComponent.this.settingChange(e);
            }
        });
        this.gridTrue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiGraphGuiComponent.this.settingChange(e);
            }
        });
        this.gridFalse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiGraphGuiComponent.this.settingChange(e);
            }
        });
        this.zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double zoom = ((MultiGraphGuiComponent)MultiGraphGuiComponent.this).view.getGraphSetting().zoom;
                double scale = Math.floor(Double.parseDouble(MultiGraphGuiComponent.this.xMarginText.getText()) * zoom * 10.0) / 10.0;
                MultiGraphGuiComponent.this.xMarginText.setText(Double.toString(scale));
                scale = Math.floor(Double.parseDouble(MultiGraphGuiComponent.this.yMarginText.getText()) * zoom * 10.0) / 10.0;
                MultiGraphGuiComponent.this.yMarginText.setText(Double.toString(scale));
                MultiGraphGuiComponent.this.settingChange(e);
            }
        });
        this.zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double zoom = ((MultiGraphGuiComponent)MultiGraphGuiComponent.this).view.getGraphSetting().zoom;
                double scale = Math.floor(Double.parseDouble(MultiGraphGuiComponent.this.xMarginText.getText()) / zoom * 10.0) / 10.0;
                if (scale < 0.2) {
                    scale = 0.2;
                }
                MultiGraphGuiComponent.this.xMarginText.setText(Double.toString(scale));
                scale = Math.floor(Double.parseDouble(MultiGraphGuiComponent.this.yMarginText.getText()) / zoom * 10.0) / 10.0;
                if (scale < 0.2) {
                    scale = 0.2;
                }
                MultiGraphGuiComponent.this.yMarginText.setText(Double.toString(scale));
                MultiGraphGuiComponent.this.settingChange(e);
            }
        });
        this.show();
        this.addUpdateClockListener(this);
    }

    public void terminate() {
        this.removeUpdateClockListener(this);
    }

    public void clockGained(UpdateClockEvent e) {
        this.view.repaint();
    }

    public void settingChange(ActionEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (comp instanceof JButton) {
            this.view.getGraphSetting().xScale = Double.parseDouble(this.xMarginText.getText());
            this.view.getGraphSetting().yScale = Double.parseDouble(this.yMarginText.getText());
            this.view.repaint();
        }
        if (comp instanceof JRadioButton) {
            if (comp.equals(this.gridTrue)) {
                this.view.getGraphSetting().isWriteHorizonalGrid = true;
                this.view.getGraphSetting().isWriteVerticalGrid = true;
                this.view.repaint();
            } else if (comp.equals(this.gridFalse)) {
                this.view.getGraphSetting().isWriteHorizonalGrid = false;
                this.view.getGraphSetting().isWriteVerticalGrid = false;
                this.view.repaint();
            }
        }
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
    }

    public void worldClosed(ModelContainerEvent ev) {
    }

    public void worldOpened(ModelContainerEvent ev) {
        this.view.repaint();
    }

    public MultiGraphView getView() {
        return this.view;
    }

    public void setView(MultiGraphView view) {
        this.view = view;
    }
}

