/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.legacy.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.boxed_economy.components.datapresentation.graph.legacy.viewer.GraphSetting;
import org.boxed_economy.components.datapresentation.graph.model.GraphModel;

public class MultiGraphView
extends JPanel {
    private List models;
    private GraphSetting setting;
    private List colors;
    private int horizonalGridWidth;
    private int verticalGridHeight;
    private int xStart;
    private int yStart;
    private int width;
    private int height;

    public MultiGraphView() {
        this.initialize();
        this.makeColors();
    }

    public void initialize() {
        this.setting = new GraphSetting();
        this.models = new ArrayList();
    }

    private void makeColors() {
        this.colors = new ArrayList();
        this.colors.add(Color.BLUE);
        this.colors.add(Color.RED);
        this.colors.add(Color.GREEN);
        this.colors.add(Color.MAGENTA);
        this.colors.add(Color.CYAN);
        this.colors.add(Color.ORANGE);
        this.colors.add(Color.DARK_GRAY);
        this.colors.add(Color.PINK);
        this.colors.add(Color.LIGHT_GRAY);
        this.colors.add(Color.YELLOW);
        this.colors.add(Color.BLACK);
        this.colors.add(Color.WHITE);
        this.colors.remove(this.setting.backGroundColor);
        this.colors.remove(this.setting.axisColor);
        this.colors.remove(this.setting.graduationColor);
        this.colors.remove(this.setting.gridColor);
    }

    public void addGraphModel(GraphModel m) {
        this.models.add(m);
        this.repaint();
    }

    private double getMaxX() {
        double r = this.setting.minimumX;
        Iterator i = this.models.iterator();
        while (i.hasNext()) {
            GraphModel m = (GraphModel)i.next();
            if (!(r + this.setting.maxXmargin < m.getPoints().getMaxX())) continue;
            r = m.getPoints().getMaxX();
        }
        return r + this.setting.maxXmargin;
    }

    private double getMaxY() {
        double r = this.setting.minimumY;
        Iterator i = this.models.iterator();
        while (i.hasNext()) {
            GraphModel m = (GraphModel)i.next();
            if (!(r + this.setting.maxYmargin < m.getPoints().getMaxY())) continue;
            r = m.getPoints().getMaxY();
        }
        return r + this.setting.maxYmargin;
    }

    private double getMinX() {
        double r = 0.0;
        Iterator i = this.models.iterator();
        while (i.hasNext()) {
            GraphModel m = (GraphModel)i.next();
            if (!(r > m.getPoints().getMinX())) continue;
            r = m.getPoints().getMinX();
        }
        return r;
    }

    private double getMinY() {
        double r = 0.0;
        Iterator i = this.models.iterator();
        while (i.hasNext()) {
            GraphModel m = (GraphModel)i.next();
            if (!(r > m.getPoints().getMinY())) continue;
            r = m.getPoints().getMinY();
        }
        return r;
    }

    public GraphSetting getGraphSetting() {
        return this.setting;
    }

    private void initializeParameter() {
        this.setBackground(this.setting.backGroundColor);
        int newWidth = (int)(this.getMaxX() * this.setting.xScale) + this.setting.startPointMargin;
        int newHeight = (int)(this.getMaxY() * this.setting.yScale) + this.setting.startPointMargin;
        this.setPreferredSize(new Dimension(newWidth, newHeight));
        this.revalidate();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.xStart = this.setting.startPointMargin;
        this.yStart = this.height - this.setting.startPointMargin;
        this.horizonalGridWidth = (int)(this.setting.xScale * this.setting.xGraduationUnit);
        if (this.horizonalGridWidth <= 0) {
            this.horizonalGridWidth = 1;
        }
        this.verticalGridHeight = (int)(this.setting.yScale * this.setting.yGraduationUnit);
        if (this.verticalGridHeight <= 0) {
            this.verticalGridHeight = 1;
        }
    }

    public void paintComponent(Graphics g) {
        int graduationLength;
        int counter;
        super.paintComponent(g);
        this.initializeParameter();
        g.setColor(this.setting.gridColor);
        if (this.setting.isWriteVerticalGrid) {
            int x = this.xStart;
            while (x < this.width) {
                g.drawLine(x, 0, x, this.yStart);
                x += this.horizonalGridWidth;
            }
        }
        if (this.setting.isWriteHorizonalGrid) {
            int y = this.yStart;
            while (y > 0) {
                g.drawLine(this.xStart, y, this.width, y);
                y -= this.verticalGridHeight;
            }
        }
        g.setColor(this.setting.graduationColor);
        if (this.setting.isWriteVerticalGraduation) {
            counter = 0;
            int x = this.xStart;
            while (x < this.width) {
                graduationLength = this.setting.graduationShortLength;
                if (counter % this.setting.divineY == 0) {
                    graduationLength = this.setting.graduationLongLength;
                    g.drawString(this.getXGraduationString(counter), x, this.yStart + this.setting.graduateNumberStringY);
                }
                g.drawLine(x, this.yStart, x, this.yStart + graduationLength);
                ++counter;
                x += this.horizonalGridWidth;
            }
        }
        if (this.setting.isWriteHorizonalGraduation) {
            counter = 0;
            int y = this.yStart;
            while (y > 0) {
                graduationLength = this.setting.graduationShortLength;
                if (counter % this.setting.divineX == 0) {
                    graduationLength = this.setting.graduationLongLength;
                    g.drawString(this.getYGraduationString(counter), this.xStart - this.setting.graduateNumberStringX, y);
                }
                g.drawLine(this.xStart - graduationLength, y, this.xStart, y);
                ++counter;
                y -= this.verticalGridHeight;
            }
        }
        g.setColor(this.setting.axisColor);
        ArrayList<String> yAxisStr = new ArrayList<String>();
        String xAxisStr = "";
        Iterator is = this.models.iterator();
        while (is.hasNext()) {
            GraphModel gm = (GraphModel)is.next();
            yAxisStr.add(new String(String.valueOf(gm.getAxisY().getName()) + "(" + gm.getAxisY().getUnitName() + ")"));
            xAxisStr = String.valueOf(xAxisStr) + gm.getAxisX().getName() + "(" + gm.getAxisX().getUnitName() + ")";
            if (!is.hasNext()) continue;
            xAxisStr = String.valueOf(xAxisStr) + "/";
        }
        g.drawLine(this.xStart, 0, this.xStart, this.height);
        Iterator iya = yAxisStr.iterator();
        int sy = 0;
        while (iya.hasNext()) {
            String s = (String)iya.next();
            if (iya.hasNext()) {
                s = String.valueOf(s) + "/";
            }
            g.drawString(s, this.setting.unitNameMarginY, this.yStart / 2 + (sy += 10));
        }
        g.drawLine(0, this.yStart, this.width, this.yStart);
        g.drawString(xAxisStr, (this.width + this.xStart) / 2, this.height - this.setting.unitNameMarginX);
        int color = 0;
        int hx = this.xStart + 3;
        Iterator i = this.models.iterator();
        while (i.hasNext()) {
            g.setColor((Color)this.colors.get(color++ % this.colors.size()));
            GraphModel m = (GraphModel)i.next();
            g.drawString(m.getLabel(), hx, this.height - this.setting.unitNameMarginX + 20);
            hx = hx + m.getLabel().length() * 10 + 15;
            Iterator points = m.getPoints().iterator();
            Point previous = this.scale(this.setting.startPoint);
            while (points.hasNext()) {
                Point current = this.scale((Point)points.next());
                g.drawLine((int)previous.getX(), (int)previous.getY(), (int)current.getX(), (int)current.getY());
                previous = current;
            }
        }
    }

    private String getXGraduationString(int counter) {
        double value = (double)counter * this.setting.xGraduationUnit;
        if (this.setting.isWriteAsDoubleX) {
            return Double.toString(value);
        }
        return Integer.toString((int)value);
    }

    private String getYGraduationString(int counter) {
        double value = (double)counter * this.setting.yGraduationUnit;
        if (this.setting.isWriteAsDoubleY) {
            return Double.toString(value);
        }
        return Integer.toString((int)value);
    }

    private Point scale(Point source) {
        double x = source.getX() * this.setting.xScale + (double)this.xStart;
        double y = (double)this.yStart - source.getY() * this.setting.yScale;
        return new Point((int)x, (int)y);
    }
}

