/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.model;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PointList {
    private List points = new ArrayList();
    private Point2D.Double minX = null;
    private Point2D.Double minY = null;
    private Point2D.Double maxX = null;
    private Point2D.Double maxY = null;

    public PointList() {
    }

    public PointList(PointList another) {
        this.addAll(another);
    }

    public void addAll(PointList another) {
        Iterator i = another.iterator();
        while (i.hasNext()) {
            Point2D.Double p = (Point2D.Double)i.next();
            this.add(new Point2D.Double(p.x, p.y));
        }
    }

    public void add(Point2D.Double p) {
        this.addValid(p);
        this.points.add(p);
    }

    public boolean remove(Point2D.Double p) {
        return this.points.remove(p);
    }

    public Point2D.Double remove(int index) {
        return (Point2D.Double)this.points.remove(index);
    }

    public void translate(int dx, int dy) {
        Iterator i = this.points.iterator();
        while (i.hasNext()) {
            Point p = (Point)i.next();
            p.translate(dx, dy);
        }
    }

    public void scale(double sx, double sy) {
        Iterator i = this.points.iterator();
        while (i.hasNext()) {
            Point2D.Double p = (Point2D.Double)i.next();
            p.x *= sx;
            p.y *= sy;
        }
    }

    private void addValid(Point2D.Double p) {
        if (p.getY() <= this.getMinY()) {
            this.minY = p;
        }
        if (p.getY() >= this.getMaxY()) {
            this.maxY = p;
        }
        if (p.getX() <= this.getMinX()) {
            this.minX = p;
        }
        if (p.getX() >= this.getMaxX()) {
            this.maxX = p;
        }
    }

    public double getMinX() {
        return this.minX == null ? 0.0 : this.minX.getX();
    }

    public double getMaxX() {
        return this.maxX == null ? 0.0 : this.maxX.getX();
    }

    public double getMinY() {
        return this.minY == null ? 0.0 : this.minY.getY();
    }

    public double getMaxY() {
        return this.maxY == null ? 0.0 : this.maxY.getY();
    }

    public void clear() {
        this.points.clear();
    }

    public Iterator iterator() {
        return this.points.iterator();
    }
}

