/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.graph.viewer.EasySettingPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.GraphCanvas;
import org.boxed_economy.components.datapresentation.graph.viewer.GraphContainerBorderLayout;
import org.boxed_economy.components.datapresentation.graph.viewer.GraphDataListPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.axis.XAxisContainerPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.axis.YAxisContainerPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.common.OverViewPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public class GraphContainerPanel
extends JPanel {
    private GGraphContainer container;
    private JScrollPane graphCanvasScrollPane = new JScrollPane();
    private GraphCanvas graphCanvas = new GraphCanvas();
    private XAxisContainerPanel xAxisContainerPanel = new XAxisContainerPanel();
    private YAxisContainerPanel yAxisContainerPanel = new YAxisContainerPanel();
    private OverViewPanel overviewPanel = new OverViewPanel();
    private GraphDataListPanel datalistPanel = new GraphDataListPanel();
    private EasySettingPanel easySettingPanel = new EasySettingPanel();

    public GraphContainerPanel(GGraphContainer container) {
        this.container = container;
        this.initialize();
    }

    private void initialize() {
        JPanel centerPanel = new JPanel();
        this.initializeCenterPanel(centerPanel);
        JPanel eastPanel = new JPanel();
        this.initializeEastPanel(eastPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)centerPanel, "Center");
        this.add((Component)eastPanel, "East");
    }

    private void initializeEastPanel(JPanel panel) {
        panel.setLayout(new BorderLayout());
        JPanel descriptionPanel = new JPanel();
        this.initializeDescriptionPanel(descriptionPanel);
        JPanel southEastPanel = new JPanel();
        this.initializeSouthEastPanel(southEastPanel);
        panel.add((Component)descriptionPanel, "Center");
        panel.add((Component)southEastPanel, "South");
    }

    private void initializeSouthEastPanel(JPanel panel) {
        panel.setLayout(new BorderLayout());
        JPanel easySettingPanel = new JPanel();
        this.initializeEasySettingPanel(easySettingPanel);
        JPanel overviewPanel = new JPanel();
        this.initializeOverviewPanel(overviewPanel);
        panel.add((Component)easySettingPanel, "North");
        panel.add((Component)overviewPanel, "Center");
    }

    private void initializeDescriptionPanel(JPanel panel) {
        panel.setBorder(BorderFactory.createTitledBorder(DPResource.get("GraphContainerPanel.Data_Explanation")));
        panel.setLayout(new BorderLayout());
        this.datalistPanel.setContainer(this.container);
        panel.add(this.datalistPanel);
    }

    private void initializeEasySettingPanel(JPanel panel) {
        panel.setBorder(BorderFactory.createTitledBorder(DPResource.get("GraphContainerPanel.Easy_Setting")));
        panel.setLayout(new BorderLayout());
        this.easySettingPanel.setContainer(this.container);
        panel.add(this.easySettingPanel);
    }

    private void initializeOverviewPanel(JPanel panel) {
        panel.setBorder(BorderFactory.createTitledBorder(DPResource.get("GraphContainerPanel.Overview")));
        panel.setLayout(new BorderLayout());
        this.overviewPanel.setViewport(this.graphCanvasScrollPane.getViewport());
        this.overviewPanel.setPreferredSize(new Dimension(120, 90));
        panel.add(this.overviewPanel);
    }

    private void initializeCenterPanel(JPanel panel) {
        panel.setLayout(new GraphContainerBorderLayout());
        this.graphCanvas.setContainer(this.container);
        this.graphCanvasScrollPane.setViewportView(this.graphCanvas);
        panel.add((Component)this.graphCanvasScrollPane, "Center");
        this.xAxisContainerPanel.setViewport(this.graphCanvasScrollPane.getViewport());
        this.xAxisContainerPanel.setContainer(this.container);
        panel.add((Component)this.xAxisContainerPanel, "South");
        this.yAxisContainerPanel.setViewport(this.graphCanvasScrollPane.getViewport());
        this.yAxisContainerPanel.setContainer(this.container);
        panel.add((Component)this.yAxisContainerPanel, "West");
    }

    public void update() {
        this.xAxisContainerPanel.update();
        this.yAxisContainerPanel.update();
        this.datalistPanel.update();
        this.overviewPanel.update();
    }

    public GraphCanvas getGraphCanvas() {
        return this.graphCanvas;
    }

    public JScrollPane getGraphCanvasScrollPane() {
        return this.graphCanvasScrollPane;
    }
}

