/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.axis;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.ac.keio.sfc.crew.collection.ListCoordinator;
import jp.ac.keio.sfc.crew.collection.ValueChangeListener;
import org.boxed_economy.components.datapresentation.graph.viewer.axis.AbstractAxisPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public abstract class AbstractAxisContainerPanel
extends JPanel
implements ValueChangeListener,
ChangeListener {
    private GGraphContainer container;
    private JViewport viewport;
    private ListCoordinator coordinator = new ListCoordinator(this);
    private Map panels = new HashMap();

    public AbstractAxisContainerPanel() {
        this.setLayout(this.createLayout());
    }

    public GGraphContainer getContainer() {
        return this.container;
    }

    public void setContainer(GGraphContainer container) {
        this.container = container;
    }

    public void setViewport(JViewport viewport) {
        if (this.viewport != null) {
            this.unhookListeners();
        }
        this.viewport = viewport;
        if (this.viewport != null) {
            this.hookListeners();
        }
    }

    private void unhookListeners() {
        this.viewport.removeChangeListener(this);
    }

    private void hookListeners() {
        this.viewport.addChangeListener(this);
    }

    public void update() {
        if (this.viewport != null && this.container != null) {
            this.coordinator.setList(this.getAxisList());
        }
        Iterator i = this.panels.values().iterator();
        while (i.hasNext()) {
            AbstractAxisPanel panel = (AbstractAxisPanel)i.next();
            panel.update();
        }
    }

    public void valueAdded(Object value, int index) {
        GAxis axis = (GAxis)value;
        AbstractAxisPanel panel = this.createPanel(axis);
        this.panels.put(axis, panel);
        this.add((Component)panel, index);
    }

    public void valueRemoved(Object value) {
        GAxis axis = (GAxis)value;
        JPanel panel = (JPanel)this.panels.get(axis);
        this.remove(panel);
    }

    public void valueReorderd(Object value, int index) {
        GAxis axis = (GAxis)value;
        JPanel panel = (JPanel)this.panels.get(axis);
        this.remove(panel);
        this.add((Component)panel, index);
    }

    public void stateChanged(ChangeEvent e) {
        Point position = this.viewport.getViewPosition();
        Iterator i = this.panels.values().iterator();
        while (i.hasNext()) {
            AbstractAxisPanel panel = (AbstractAxisPanel)i.next();
            panel.viewPositionChanged(position);
        }
    }

    public abstract List getAxisList();

    public abstract LayoutManager createLayout();

    public abstract AbstractAxisPanel createPanel(GAxis var1);
}

