/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.axis;

import java.awt.Color;
import java.awt.Point;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public abstract class AbstractAxisPanel
extends JPanel {
    private static NumberFormatter FORMATTER = new NumberFormatter(new DecimalFormat("0.##"));
    public static final int MEASURE_WIDTH = 30;
    public static final int MEASURE_LENGTH = 5;
    private GAxis axis;
    private GGraphContainer container;

    public AbstractAxisPanel(GGraphContainer container, GAxis axis) {
        this.container = container;
        this.axis = axis;
        this.setBackground(Color.white);
    }

    public GAxis getAxis() {
        return this.axis;
    }

    public GGraphContainer getContainer() {
        return this.container;
    }

    protected String formatValue(double value) {
        try {
            return FORMATTER.valueToString(new Double(value));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String createLabelText() {
        String unitName;
        String name = this.getAxis().getModel().getName();
        if (name == null || name.length() == 0) {
            name = "No AxisName";
        }
        if ((unitName = this.getAxis().getModel().getUnitName()) == null || unitName.length() == 0) {
            unitName = "Unknown";
        }
        return String.valueOf(name) + "(" + unitName + ")";
    }

    public abstract void update();

    public abstract void viewPositionChanged(Point var1);
}

