/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.axis;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class VerticalLabel
extends JComponent {
    private static final BufferedImageOp OP = new AffineTransformOp(AffineTransform.getRotateInstance(Math.toRadians(90.0)), 1);
    private String text = "";
    private BufferedImage buf;

    public void setText(String text) {
        if (text == null) {
            return;
        }
        this.text = text;
        this.refreshImage();
    }

    private void refreshImage() {
        if (this.getFont() == null) {
            return;
        }
        int width = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.text);
        width = Math.max(1, width);
        int height = this.getWidth();
        height = Math.max(1, height);
        this.buf = new BufferedImage(width, height, 6);
        Graphics2D g2d = this.buf.createGraphics();
        g2d.setColor(this.getForeground());
        g2d.setFont(this.getFont());
        g2d.drawString(this.text, 0, height * 2 / 3);
        g2d.dispose();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.buf == null) {
            this.refreshImage();
        }
        if (this.buf != null && g instanceof Graphics2D) {
            ((Graphics2D)g).drawImage(this.buf, OP, this.getWidth(), this.getHeight() / 2 - this.buf.getWidth() / 2);
        }
    }
}

