/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.axis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import org.boxed_economy.components.datapresentation.graph.viewer.axis.AbstractAxisDescriptionPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.axis.AbstractAxisPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public class XAxisPanel
extends AbstractAxisPanel {
    private JViewport viewport = new JViewport();
    private XMeasureCanvas measureCanvas = new XMeasureCanvas();
    private XAxisDescriptionPanel descriptionPanel;

    public XAxisPanel(GGraphContainer container, GAxis axis) {
        super(container, axis);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.viewport.setView(this.measureCanvas);
        this.viewport.setBackground(Color.white);
        this.descriptionPanel = new XAxisDescriptionPanel(this.getContainer(), this.getAxis());
        this.add((Component)this.viewport, "Center");
        this.add((Component)this.descriptionPanel, "South");
    }

    public void update() {
        this.measureCanvas.setPreferredSize(new Dimension(this.getContainer().getCanvasSize().width, 30));
        this.measureCanvas.revalidate();
        this.measureCanvas.repaint();
    }

    public void viewPositionChanged(Point position) {
        Point p = this.viewport.getViewPosition();
        p.x = position.x;
        this.viewport.setViewPosition(p);
    }

    class XMeasureCanvas
    extends JComponent {
        XMeasureCanvas() {
        }

        public void paintComponent(Graphics g) {
            double scale;
            Point2D.Double origin = XAxisPanel.this.getContainer().getOrigin();
            int rightSide = this.getWidth();
            boolean leftSide = false;
            double step = XAxisPanel.this.getAxis().getMeasure().getStep();
            double measure = step * (scale = XAxisPanel.this.getAxis().getScale().getValue());
            if (measure < 1.0) {
                return;
            }
            int i = 0;
            while (measure * (double)i + origin.x < (double)rightSide) {
                this.drawMeasure(g, origin, step, scale, measure, i);
                ++i;
            }
            i = 0;
            while (measure * (double)i + origin.x > (double)leftSide) {
                this.drawMeasure(g, origin, step, scale, measure, i);
                --i;
            }
        }

        private void drawMeasure(Graphics g, Point2D.Double origin, double step, double scale, double measure, int i) {
            int x = (int)(measure * (double)i) + (int)origin.x;
            int len = 5;
            if (i % 5 == 0) {
                len *= 2;
            }
            g.drawLine(x, 0, x, len);
            if (i % 10 == 0) {
                double value = step * (double)i;
                g.drawString(XAxisPanel.this.formatValue(value), x, len * 2);
            }
        }
    }

    class XAxisDescriptionPanel
    extends AbstractAxisDescriptionPanel {
        public XAxisDescriptionPanel(GGraphContainer container, GAxis axis) {
            super(container, axis);
        }

        protected void initializeComponent() {
            this.setLayout(new BorderLayout());
            JLabel label = new JLabel();
            label.setText(XAxisPanel.this.createLabelText());
            label.setHorizontalAlignment(0);
            label.setHorizontalTextPosition(0);
            this.add((Component)label, "Center");
            this.add((Component)this.buttonsPanel, "West");
        }

        protected LayoutManager createButtonPanelLayout() {
            this.buttonsPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            return new FlowLayout(3, 0, 0);
        }
    }
}

