/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.axis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JViewport;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.components.datapresentation.graph.viewer.axis.AbstractAxisDescriptionPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.axis.AbstractAxisPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.axis.VerticalLabel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public class YAxisPanel
extends AbstractAxisPanel {
    private JViewport viewport = new JViewport();
    private YMeasureCanvas measureCanvas = new YMeasureCanvas();
    private YAxisDescriptionPanel descriptionPanel;

    public YAxisPanel(GGraphContainer container, GAxis axis) {
        super(container, axis);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.viewport.setView(this.measureCanvas);
        this.viewport.setBackground(Color.white);
        this.descriptionPanel = new YAxisDescriptionPanel(this.getContainer(), this.getAxis());
        this.add((Component)this.descriptionPanel, "West");
        this.add((Component)this.viewport, "Center");
    }

    public void update() {
        this.measureCanvas.setPreferredSize(new Dimension(30, this.getContainer().getCanvasSize().height));
        this.measureCanvas.revalidate();
        this.measureCanvas.repaint();
    }

    public void viewPositionChanged(Point position) {
        Point p = this.viewport.getViewPosition();
        p.y = position.y;
        this.viewport.setViewPosition(p);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    class YMeasureCanvas
    extends JComponent {
        YMeasureCanvas() {
        }

        public void paintComponent(Graphics g) {
            double scale;
            Point2D.Double origin = YAxisPanel.this.getContainer().getOrigin();
            boolean top = false;
            int bottom = this.getHeight();
            double step = YAxisPanel.this.getAxis().getMeasure().getStep();
            double measure = step * (scale = YAxisPanel.this.getAxis().getScale().getValue());
            if (measure < 1.0) {
                return;
            }
            int i = 0;
            while (-(measure * (double)i) + origin.y > (double)top) {
                this.drawMeasure(g, origin, step, scale, measure, i);
                ++i;
            }
            i = 0;
            while (-(measure * (double)i) + origin.y < (double)bottom) {
                this.drawMeasure(g, origin, step, scale, measure, i);
                --i;
            }
        }

        private void drawMeasure(Graphics g, Point2D.Double origin, double step, double scale, double measure, int i) {
            int y = -((int)(measure * (double)i)) + (int)origin.y;
            ++y;
            int len = 5;
            if (i % 5 == 0) {
                len *= 2;
            }
            g.drawLine(this.getWidth() - len, y, this.getWidth(), y);
            if (i % 10 == 0) {
                double value = step * (double)i;
                g.drawString(YAxisPanel.this.formatValue(value), 0, y);
            }
        }
    }

    class YAxisDescriptionPanel
    extends AbstractAxisDescriptionPanel {
        public YAxisDescriptionPanel(GGraphContainer container, GAxis axis) {
            super(container, axis);
        }

        protected void initializeComponent() {
            this.setLayout(new BorderLayout());
            VerticalLabel label = new VerticalLabel();
            label.setText(YAxisPanel.this.createLabelText());
            this.add((Component)label, "Center");
            this.add((Component)this.buttonsPanel, "South");
        }

        protected LayoutManager createButtonPanelLayout() {
            return new VerticalFlowLayout(0);
        }
    }
}

