/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public abstract class AbstractColorChooseButton
extends JButton {
    public AbstractColorChooseButton() {
        this.setBackground(Color.WHITE);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractColorChooseButton.this.openDialog();
            }
        });
        this.update();
    }

    protected void openDialog() {
        Color color = JColorChooser.showDialog(this, this.getTitle(), this.getColor());
        this.setColor(color);
        this.update();
    }

    public void update() {
        Dimension size = this.getIconSize();
        BufferedImage buf = new BufferedImage(size.width, size.height, 6);
        Graphics2D g = buf.createGraphics();
        g.setColor(this.getColor());
        this.drawExplanation(g);
        g.dispose();
        this.setIcon(new ImageIcon(buf));
    }

    public abstract String getTitle();

    public abstract Dimension getIconSize();

    public abstract void drawExplanation(Graphics var1);

    public abstract Color getColor();

    public abstract void setColor(Color var1);
}

