/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.boxed_economy.components.datapresentation.graph.viewer.common.Scale;

public class OverViewPanel
extends JPanel
implements ChangeListener {
    private static final BufferedImageOp OP = new AffineTransformOp(AffineTransform.getTranslateInstance(0.0, 0.0), 1);
    private JViewport viewport;
    private BufferedImage bufImage;

    public OverViewPanel() {
        this.initialize();
    }

    private void initialize() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                OverViewPanel.this.moveViewPoint(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                OverViewPanel.this.moveViewPoint(e);
            }
        });
    }

    public void setViewport(JViewport viewport) {
        if (this.viewport != null) {
            this.unhookListeners();
        }
        this.viewport = viewport;
        if (this.viewport != null) {
            this.hookListeners();
        }
    }

    private void unhookListeners() {
        this.viewport.removeChangeListener(this);
    }

    private void hookListeners() {
        this.viewport.addChangeListener(this);
    }

    private void moveViewPoint(MouseEvent e) {
        if (this.viewport == null) {
            return;
        }
        Dimension compSize = this.viewport.getViewSize();
        Dimension viewSize = this.viewport.getSize();
        int x = e.getX();
        int y = e.getY();
        Scale scale = this.getScale();
        x = (int)((double)x * scale.reverseX());
        y = (int)((double)y * scale.reverseY());
        x -= viewSize.width / 2;
        y -= viewSize.height / 2;
        x = Math.max(0, x);
        y = Math.max(0, y);
        x = Math.min(x, compSize.width - viewSize.width);
        y = Math.min(y, compSize.height - viewSize.height);
        this.viewport.setViewPosition(new Point(x, y));
    }

    public void update() {
        this.createBufImage();
        this.repaint();
    }

    private void createBufImage() {
        if (this.viewport == null) {
            return;
        }
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        this.bufImage = new BufferedImage(this.getWidth(), this.getHeight(), 6);
        Graphics2D g2d = this.bufImage.createGraphics();
        Scale scale = this.getScale();
        AffineTransform tx = AffineTransform.getScaleInstance(scale.x, scale.y);
        g2d.setTransform(tx);
        JComponent comp = (JComponent)this.viewport.getView();
        comp.print(g2d);
        g2d.dispose();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.createBufImage();
        Graphics2D g2d = (Graphics2D)g;
        if (this.bufImage != null) {
            g2d.drawImage(this.bufImage, OP, 0, 0);
        }
        if (this.bufImage != null) {
            this.drawPositionRect(g2d);
        }
    }

    private void drawPositionRect(Graphics2D g2d) {
        g2d.setColor(Color.red);
        g2d.setStroke(new BasicStroke(2.0f));
        Rectangle viewRect = this.viewport.getViewRect();
        Scale scale = this.getScale();
        this.scaleRect(viewRect, scale);
        g2d.draw(viewRect);
    }

    private void scaleRect(Rectangle viewRect, Scale scale) {
        viewRect.x = (int)((double)viewRect.x * scale.x);
        viewRect.y = (int)((double)viewRect.y * scale.y);
        viewRect.width = (int)((double)viewRect.width * scale.x);
        viewRect.height = (int)((double)viewRect.height * scale.y);
    }

    private Scale getScale() {
        JComponent comp = (JComponent)this.viewport.getView();
        int w = this.getWidth();
        int h = this.getHeight();
        double sx = (double)w / (double)comp.getWidth();
        double sy = (double)h / (double)comp.getHeight();
        return new Scale(sx, sy);
    }

    public void stateChanged(ChangeEvent e) {
        this.update();
    }
}

