/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.graph.viewer.common.AbstractColorChooseButton;
import org.boxed_economy.components.datapresentation.graph.viewer.dialogs.AbstractDataDependentSettingPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.dialogs.CenterLayout;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GDataSet;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public class DataSettingDialogPanel
extends JPanel {
    private GGraphContainer container;
    private List xDependentSettingPanels = new ArrayList();
    private List yDependentSettingPanels = new ArrayList();

    public DataSettingDialogPanel(GGraphContainer container) {
        this.container = container;
        this.setLayout(new GridLayout(0, 4));
        this.initializeTitles();
        this.initializeDataSets(container);
    }

    private void initializeTitles() {
        this.add(new JLabel(DPResource.get("DataSettingDialogPanel.Data_Name"), 0));
        this.add(new JLabel(DPResource.get("DataSettingDialogPanel.Line_Color"), 0));
        this.add(new JLabel(DPResource.get("DataSettingDialogPanel.Marge_X_Axis"), 0));
        this.add(new JLabel(DPResource.get("DataSettingDialogPanel.Marge_Y_Axis"), 0));
    }

    private void initializeDataSets(GGraphContainer container) {
        Iterator i = container.getGraph().getDataSets().iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            DataSettingPanel dataSettingPanel = new DataSettingPanel(data);
            dataSettingPanel.initialize(this);
        }
    }

    class DataSettingPanel {
        private GDataSet data;

        DataSettingPanel(GDataSet data) {
            this.data = data;
        }

        public void initialize(JComponent comp) {
            JLabel label = new JLabel(this.data.getModel().getLabel(), 0);
            comp.add(label);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new CenterLayout());
            ColorChooseButton button = new ColorChooseButton();
            buttonPanel.add(button);
            comp.add(buttonPanel);
            XDataDependentSettingPanel xDependencyPanel = new XDataDependentSettingPanel(DataSettingDialogPanel.this.container, this.data);
            comp.add(xDependencyPanel);
            DataSettingDialogPanel.this.xDependentSettingPanels.add(xDependencyPanel);
            YDataDependentSettingPanel yDependencyPanel = new YDataDependentSettingPanel(DataSettingDialogPanel.this.container, this.data);
            comp.add(yDependencyPanel);
            DataSettingDialogPanel.this.yDependentSettingPanels.add(yDependencyPanel);
        }

        class ColorChooseButton
        extends AbstractColorChooseButton {
            ColorChooseButton() {
            }

            public void drawExplanation(Graphics g) {
                g.fillRect(0, 0, 20, 5);
            }

            public Color getColor() {
                return DataSettingPanel.this.data.getColor();
            }

            public Dimension getIconSize() {
                return new Dimension(20, 5);
            }

            public String getTitle() {
                return DPResource.get("DataSettingDialogPanel.Choose_Color");
            }

            public void setColor(Color color) {
                DataSettingPanel.this.data.setColor(color);
            }
        }

        class XDataDependentSettingPanel
        extends AbstractDataDependentSettingPanel {
            public XDataDependentSettingPanel(GGraphContainer container, GDataSet data) {
                super(container, data);
            }

            public GDataSet getDependent() {
                return this.getData().getDependentX();
            }

            public void setDependent(GDataSet data) {
                this.getData().setDependentX(data);
            }

            public List getDependentList(GDataSet data) {
                return data.getDependentXList();
            }

            public boolean isDependent() {
                return this.getData().getDependentX() != null;
            }

            public void updated() {
                Iterator i = DataSettingDialogPanel.this.xDependentSettingPanels.iterator();
                while (i.hasNext()) {
                    XDataDependentSettingPanel panel = (XDataDependentSettingPanel)i.next();
                    panel.update();
                }
                DataSettingDialogPanel.this.container.update();
            }
        }

        class YDataDependentSettingPanel
        extends AbstractDataDependentSettingPanel {
            public YDataDependentSettingPanel(GGraphContainer container, GDataSet data) {
                super(container, data);
            }

            public GDataSet getDependent() {
                return this.getData().getDependentY();
            }

            public void setDependent(GDataSet data) {
                this.getData().setDependentY(data);
            }

            public List getDependentList(GDataSet data) {
                return data.getDependentYList();
            }

            public boolean isDependent() {
                return this.getData().getDependentY() != null;
            }

            public void updated() {
                Iterator i = DataSettingDialogPanel.this.yDependentSettingPanels.iterator();
                while (i.hasNext()) {
                    YDataDependentSettingPanel panel = (YDataDependentSettingPanel)i.next();
                    panel.update();
                }
                DataSettingDialogPanel.this.container.update();
            }
        }
    }
}

