/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.model;

import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;

public class GMeasure {
    public static final double DEFAULT_STEP = 5.0;
    private GAxis axis;
    private boolean auto = true;
    private boolean showGrid = false;
    private double step = 5.0;

    public GMeasure(GAxis axis) {
        this.axis = axis;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    public void setStep(double value) {
        this.step = value;
    }

    public double getStep() {
        if (this.auto) {
            return this.getProperValue(5.0 * (1.0 / this.axis.getScale().getValue()));
        }
        return this.step;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    private double getProperValue(double value) {
        if (value >= 1.0) {
            return (int)value;
        }
        int validPlace = this.getValidPlace(value);
        int power = (int)Math.pow(10.0, validPlace);
        int tmp = (int)(value * (double)power);
        value = (double)tmp / (double)power;
        return value;
    }

    private int getValidPlace(double value) {
        int place = 0;
        do {
            ++place;
        } while ((int)(value *= 10.0) == 0);
        return place;
    }

    public static void main(String[] args) {
        GMeasure measure = new GMeasure(null);
        System.out.println(measure.getProperValue(4.2));
        System.out.println(measure.getProperValue(3.0));
        System.out.println(measure.getProperValue(0.18));
        System.out.println(measure.getProperValue(0.92));
        System.out.println(measure.getProperValue(0.092));
    }
}

