/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.List;

public class CSVWriter {
    private PrintWriter pw = null;

    public CSVWriter(File out) {
        try {
            this.pw = new PrintWriter(new FileOutputStream(out));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void writeLine(List data) {
        if (this.pw != null) {
            int len = data.size();
            int i = 0;
            while (i < len) {
                String dataString = this.getDataString(data.get(i));
                if (i > 0) {
                    this.pw.print(",");
                }
                this.pw.print("\"");
                this.pw.print(dataString);
                this.pw.print("\"");
                ++i;
            }
            this.pw.println();
            this.pw.flush();
        }
    }

    private String getDataString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return "null";
    }

    public synchronized void close() {
        if (this.pw != null) {
            this.pw.flush();
            this.pw.close();
            this.pw = null;
        }
    }
}

