/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.file;

import java.util.ResourceBundle;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.besp.presentation.bface.menu.Menu;
import org.boxed_economy.components.file.ExitAction;
import org.boxed_economy.components.file.FileManagerPlugin;
import org.boxed_economy.components.file.FileOpenAction;
import org.boxed_economy.components.file.FileSaveAction;
import org.boxed_economy.components.file.FileSaveAsAction;
import org.boxed_economy.components.file.ImportWorldAction;

public class FileManager
extends AbstractPresentationComponent
implements ModelContainerListener,
SimulationStateListener {
    public static ResourceBundle resource = FileManagerPlugin.resource;
    public Menu fileMenu = new Menu();
    public ActionGroup fileOperationGroup = new ActionGroup();
    public ActionGroup importGroup = new ActionGroup();
    public Menu importMenu = new Menu(resource.getString("Menu_Import"));
    public ActionGroup exitGroup = new ActionGroup();
    public Action fileOpenAction = new FileOpenAction();
    public Action fileSaveAction = new FileSaveAction();
    public Action fileSaveAsAction = new FileSaveAsAction();
    public Action importWorldAction = new ImportWorldAction();
    public Action exitAction = new ExitAction();

    public void initialize() {
        this.initializeFileMenu();
    }

    private void initializeFileMenu() {
        this.getPresentationContainer().getMenuManager().fileMenuGroup.add(this.fileMenu);
        this.fileMenu.setName(resource.getString("Menu_File"));
        this.fileMenu.add(this.fileOperationGroup);
        this.fileMenu.add(this.importGroup);
        this.fileMenu.add(this.exitGroup);
        this.fileOperationGroup.add(this.fileOpenAction);
        this.fileOperationGroup.add(this.fileSaveAsAction);
        this.fileOperationGroup.add(this.fileSaveAction);
        this.importGroup.add(this.importMenu);
        this.importGroup.add(this.importMenu);
        this.importMenu.add(this.importWorldAction);
        this.exitGroup.add(this.exitAction);
    }

    public void terminate() {
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
    }

    public void worldOpened(ModelContainerEvent ev) {
        this.fileSaveAction.setEnabled(true);
        this.fileSaveAsAction.setEnabled(true);
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
    }

    public void worldClosed(ModelContainerEvent ev) {
        this.fileSaveAction.setEnabled(false);
        this.fileSaveAsAction.setEnabled(false);
    }

    public void simulationStarted(SimulationStateEvent ev) {
        this.fileOperationGroup.setEnabled(false);
        this.importWorldAction.setEnabled(false);
    }

    public void simulationStopped(SimulationStateEvent ev) {
        this.fileOperationGroup.setEnabled(true);
        this.importWorldAction.setEnabled(true);
    }

    public void simulationStopping(SimulationStateEvent ev) {
    }
}

