/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.profiler;

import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.boxed_economy.besp.model.fmfw.FmFwObject;

public class InstanceProfilingTableModel
extends AbstractTableModel {
    private List instanceCountersCash = null;

    public InstanceProfilingTableModel() {
        this.updateCash();
    }

    private void updateCash() {
        this.instanceCountersCash = FmFwObject.getInstanceCounters();
    }

    public int getRowCount() {
        return this.instanceCountersCash.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        FmFwObject.InstanceCounter counter = (FmFwObject.InstanceCounter)this.instanceCountersCash.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return counter.getName();
            }
            case 1: {
                return new Long(counter.getAlive());
            }
            case 2: {
                return new Long(counter.getAllocated());
            }
        }
        return null;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Class";
            }
            case 1: {
                return "Alive";
            }
            case 2: {
                return "Allocated";
            }
        }
        return null;
    }

    public void fireTableDataChanged() {
        this.updateCash();
        super.fireTableDataChanged();
    }

    public String getModelString() {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.instanceCountersCash.iterator();
        while (i.hasNext()) {
            FmFwObject.InstanceCounter counter = (FmFwObject.InstanceCounter)i.next();
            buf.append(",");
            buf.append(counter.getName());
            buf.append(",");
            buf.append(counter.getAlive());
        }
        return buf.toString();
    }
}

