/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.profiler;

import java.text.NumberFormat;
import javax.swing.table.AbstractTableModel;

public class MemoryProfilingTableModel
extends AbstractTableModel {
    private static final Runtime runtime = Runtime.getRuntime();
    private static final NumberFormat formatter = NumberFormat.getInstance();
    private long freeMemory = runtime.freeMemory();
    private long maxMemory = runtime.maxMemory();
    private long totalMemory = runtime.totalMemory();

    public MemoryProfilingTableModel() {
        this.updateCash();
    }

    private void updateCash() {
        this.freeMemory = runtime.freeMemory();
        this.maxMemory = runtime.maxMemory();
        this.totalMemory = runtime.totalMemory();
    }

    public int getRowCount() {
        return 1;
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return formatter.format(this.maxMemory);
            }
            case 1: {
                return formatter.format(this.totalMemory);
            }
            case 2: {
                return formatter.format(this.freeMemory);
            }
        }
        return null;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Max Memory";
            }
            case 1: {
                return "Total Memory";
            }
            case 2: {
                return "Free Memory";
            }
        }
        return null;
    }

    public void fireTableDataChanged() {
        this.updateCash();
        super.fireTableDataChanged();
    }

    public String getModelString() {
        StringBuffer buf = new StringBuffer();
        buf.append(",");
        buf.append(this.maxMemory);
        buf.append(",");
        buf.append(this.totalMemory);
        buf.append(",");
        buf.append(this.freeMemory);
        return buf.toString();
    }
}

